package com.ejianc.business.budget.vo.comparator;

import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;

import java.util.Comparator;

public class BudgetDetailProComparatoeVo implements Comparator<BudgetProjectDetailProVO> {
    @Override
    public int compare(BudgetProjectDetailProVO c1, BudgetProjectDetailProVO c2) {
        String[] preArrs = c1.getDetailIndex().split("\\.");
        String[] sufArrs = c2.getDetailIndex().split("\\.");
        int len = preArrs.length > sufArrs.length ? preArrs.length : sufArrs.length;
        for (int i = 0; i < len; i++) {
            int preNum = 0;
            int sufNum = 0;

            if (i < preArrs.length) {
                preNum = Integer.parseInt(preArrs[i]);
            }

            if (i < sufArrs.length) {
                sufNum = Integer.parseInt(sufArrs[i]);
            }

            if (preNum > sufNum) {
                return 1;
            } else if (preNum < sufNum) {
                return -1;
            }
        }
        return 0;
    }

}

