package com.ejianc.business.cost.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 在建项目情况填报
 * 
 * @author generator
 * 
 */
public class ProjectSituationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectLevel; // 项目等级
    private BigDecimal bidTaxMny; // 中标金额
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date bidDate; // 中标时间
    private String headUser; // 负责人
    private Integer examineNum; // 考察次数
    private String entourageUser; // 随行人员
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date billDate; // 填报日期
    private Integer laborPostFlag; // 劳务派驻单
    private Integer equipmentPostFlag; // 机械派驻单
    private Integer laborSubContractFlag; // 劳务分包合同
    private Integer equipmentSubContractFlag; // 机械分包合同
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private Long departmentId; // 经办人部门
    private String departmentName; // 经办人部门
    private String remark; // 总结及建议
    private Integer billState; // 单据状态
    
    private List<ProjectSituationTeamVO> projectSituationTeamList = new ArrayList<>(); // 在建项目情况填报-劳务组织
    private List<ProjectSituationQuantityVO> projectSituationQuantityList = new ArrayList<>(); // 在建项目情况填报-工程量
    private List<ProjectSituationLaborVO> projectSituationLaborList = new ArrayList<>(); // 在建项目情况填报-劳务
    private List<ProjectSituationMaterialVO> projectSituationMaterialList = new ArrayList<>(); // 在建项目情况填报-材料
    private List<ProjectSituationEquipmentVO> projectSituationEquipmentList = new ArrayList<>(); // 在建项目情况填报-机械
    private List<ProjectSituationCostVO> projectSituationCostList = new ArrayList<>(); // 在建项目情况填报-动态成本

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectLevel() {
        return projectLevel;
    }

    public void setProjectLevel(String projectLevel) {
        this.projectLevel = projectLevel;
    }
    public BigDecimal getBidTaxMny() {
        return bidTaxMny;
    }

    public void setBidTaxMny(BigDecimal bidTaxMny) {
        this.bidTaxMny = bidTaxMny;
    }
    public Date getBidDate() {
        return bidDate;
    }

    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }
    public String getHeadUser() {
        return headUser;
    }

    public void setHeadUser(String headUser) {
        this.headUser = headUser;
    }
    public Integer getExamineNum() {
        return examineNum;
    }

    public void setExamineNum(Integer examineNum) {
        this.examineNum = examineNum;
    }
    public String getEntourageUser() {
        return entourageUser;
    }

    public void setEntourageUser(String entourageUser) {
        this.entourageUser = entourageUser;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getLaborPostFlag() {
        return laborPostFlag;
    }

    public void setLaborPostFlag(Integer laborPostFlag) {
        this.laborPostFlag = laborPostFlag;
    }
    public Integer getEquipmentPostFlag() {
        return equipmentPostFlag;
    }

    public void setEquipmentPostFlag(Integer equipmentPostFlag) {
        this.equipmentPostFlag = equipmentPostFlag;
    }
    public Integer getLaborSubContractFlag() {
        return laborSubContractFlag;
    }

    public void setLaborSubContractFlag(Integer laborSubContractFlag) {
        this.laborSubContractFlag = laborSubContractFlag;
    }
    public Integer getEquipmentSubContractFlag() {
        return equipmentSubContractFlag;
    }

    public void setEquipmentSubContractFlag(Integer equipmentSubContractFlag) {
        this.equipmentSubContractFlag = equipmentSubContractFlag;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<ProjectSituationTeamVO> getProjectSituationTeamList() {
        return projectSituationTeamList;
     }

     public void setProjectSituationTeamList(List<ProjectSituationTeamVO> projectSituationTeamList) {
        this.projectSituationTeamList = projectSituationTeamList;
     }
     public List<ProjectSituationQuantityVO> getProjectSituationQuantityList() {
        return projectSituationQuantityList;
     }

     public void setProjectSituationQuantityList(List<ProjectSituationQuantityVO> projectSituationQuantityList) {
        this.projectSituationQuantityList = projectSituationQuantityList;
     }
     public List<ProjectSituationLaborVO> getProjectSituationLaborList() {
        return projectSituationLaborList;
     }

     public void setProjectSituationLaborList(List<ProjectSituationLaborVO> projectSituationLaborList) {
        this.projectSituationLaborList = projectSituationLaborList;
     }
     public List<ProjectSituationMaterialVO> getProjectSituationMaterialList() {
        return projectSituationMaterialList;
     }

     public void setProjectSituationMaterialList(List<ProjectSituationMaterialVO> projectSituationMaterialList) {
        this.projectSituationMaterialList = projectSituationMaterialList;
     }
     public List<ProjectSituationEquipmentVO> getProjectSituationEquipmentList() {
        return projectSituationEquipmentList;
     }

     public void setProjectSituationEquipmentList(List<ProjectSituationEquipmentVO> projectSituationEquipmentList) {
        this.projectSituationEquipmentList = projectSituationEquipmentList;
     }
     public List<ProjectSituationCostVO> getProjectSituationCostList() {
        return projectSituationCostList;
     }

     public void setProjectSituationCostList(List<ProjectSituationCostVO> projectSituationCostList) {
        this.projectSituationCostList = projectSituationCostList;
     }
}
