package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 分包零星用工表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_sub_oddjob")
public class OddjobEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同ID
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 零工单号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 分包类型
     */
    @TableField("contract_type")
    private Long contractType;

    /**
     * 用工类型
     */
    @TableField("job_type")
    private Long jobType;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 分包供应商
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 分包供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 开始日期
     */
    @TableField("begin_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate;

    /**
     * 结束日期
     */
    @TableField("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 使用部位
     */
    @TableField("part_used")
    private Long partUsed;

    /**
     * 零工总金额
     */
    @TableField("job_mny")
    private BigDecimal jobMny;

    /**
     * 零工总金额（含税）
     */
    @TableField("job_tax_mny")
    private BigDecimal jobTaxMny;

    /**
     * 用工摘要
     */
    @TableField("roundup")
    private String roundup;

    /**
     * 用工前图片
     */
    @TableField("before_urls")
    private String beforeUrls;

    /**
     * 用工后图片
     */
    @TableField("after_urls")
    private String afterUrls;

    /**
     * 单据状态（审批必须字段）
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 是否结算
     */
    @TableField("settle_flag")
    private Boolean settleFlag;
    /**
     * 零工结算金额（含税）
     */
    @TableField("oddjob_settle_tax_mny")
    private BigDecimal oddjobSettleTaxMny;

    /**
     * 零工内容集合
     */
    @TableField(exist = false)
    @SubEntity(serviceName="OddjobContentServiceImpl",pidName = "oddjobId")
    private List<OddjobContentEntity> oddjobContentList;

    public BigDecimal getOddjobSettleTaxMny() {
        return oddjobSettleTaxMny;
    }

    public void setOddjobSettleTaxMny(BigDecimal oddjobSettleTaxMny) {
        this.oddjobSettleTaxMny = oddjobSettleTaxMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public Long getJobType() {
        return jobType;
    }

    public void setJobType(Long jobType) {
        this.jobType = jobType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Long getPartUsed() {
        return partUsed;
    }

    public void setPartUsed(Long partUsed) {
        this.partUsed = partUsed;
    }
    public BigDecimal getJobMny() {
        return jobMny;
    }

    public void setJobMny(BigDecimal jobMny) {
        this.jobMny = jobMny;
    }
    public BigDecimal getJobTaxMny() {
        return jobTaxMny;
    }

    public void setJobTaxMny(BigDecimal jobTaxMny) {
        this.jobTaxMny = jobTaxMny;
    }
    public String getRoundup() {
        return roundup;
    }

    public void setRoundup(String roundup) {
        this.roundup = roundup;
    }
    public String getBeforeUrls() {
        return beforeUrls;
    }

    public void setBeforeUrls(String beforeUrls) {
        this.beforeUrls = beforeUrls;
    }
    public String getAfterUrls() {
        return afterUrls;
    }

    public void setAfterUrls(String afterUrls) {
        this.afterUrls = afterUrls;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Boolean getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Boolean settleFlag) {
        this.settleFlag = settleFlag;
    }

    public List<OddjobContentEntity> getOddjobContentList() {
        return oddjobContentList;
    }

    public void setOddjobContentList(List<OddjobContentEntity> oddjobContentList) {
        this.oddjobContentList = oddjobContentList;
    }
}
