package com.ejianc.business.sub.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.sub.bean.OddjobEntity;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.vo.ChangeRecordVO;
import com.ejianc.business.sub.vo.OddjobRecordVO;
import com.ejianc.business.sub.vo.OddjobVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 分包零星用工表 前端控制器
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@RestController
@RequestMapping("oddjob")
public class OddjobController implements Serializable {

    @Autowired
    IOddjobService oddjobService;

    @Autowired
    private IOrgApi orgApi;


    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增或者修改
     * @param oddjobVO
     * @Return com.ejianc.framework.core.response.CommonResponse<OddjobVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OddjobVO> saveOrUpdate(@RequestBody OddjobVO oddjobVO) {
        OddjobVO vo = oddjobService.insertOrUpdate(oddjobVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询变更记录详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<OddjobVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddjobVO> queryDetail(Long id) {
        OddjobVO vo = oddjobService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OddjobVO>> queryList(@RequestBody QueryParam param) {
        return oddjobService.queryListVOs(param);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OddjobVO> vos) {
        return  oddjobService.deleteByIds(vos);
    }

    /**
     * 零工参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/oddjobRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OddjobVO>> oddjobRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                         @RequestParam(defaultValue = "10") Integer pageSize,
                                                         @RequestParam(value = "condition", required = false) String condition,
                                                         @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("bill_code");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);

        if(StringUtils.isNotBlank(searchText)) {
            queryParam.setSearchText(searchText);
        }

        Long contractId = null;
        Long orgId = null;
        Long projectId = null;
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("contractId")) {
                contractId = Long.valueOf(conditionMap.get("contractId").toString());
            }
            if(null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
            if(null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }
        }
        if(null != orgId) {
            queryParam.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            queryParam.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        if(null == contractId) {
            return CommonResponse.success("查询零工列表失败，合同主键为必传参数！", null);
        }
        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("project_id", new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("settle_flag", new Parameter(QueryParam.EQ, Boolean.FALSE));
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
        queryParam.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));

        IPage<OddjobEntity> pageData = oddjobService.queryPage(queryParam, false);
        IPage<OddjobVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList(pageData.getRecords(), OddjobVO.class));
        return CommonResponse.success("查询合同列表成功！", result);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description saveOrUpdate 新增查询合同转化为零工
     * @param contractId
     * @Return com.ejianc.framework.core.response.CommonResponse<OddjobVO>
     */
    @RequestMapping(value = "/queryDetailAdd", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddjobVO> queryDetailAdd(Long contractId) {
        OddjobVO vo = oddjobService.queryDetailAdd(contractId);
        return CommonResponse.success("新增查询合同转化为零工成功！",vo);
    }

    /**
     * @Author zhangwx
     * @Date 2020/5/27
     * @Description queryDetailRecord 查询记录
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<ChangeVO>
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OddjobRecordVO> queryDetailRecord(Long id) {
        OddjobRecordVO vo = oddjobService.queryDetailRecord(id);
        return CommonResponse.success("查询记录数据成功！",vo);
    }

    /**
     * 导出
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        oddjobService.excelExport(param,response);
    }
}
