package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.vo.FinishOddjobVO;
import com.ejianc.business.sub.vo.FinishVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.stream.Collectors;

/**
 * <p>
 * 分包零星用工表 审批流服务实现类
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@Service("finish")
public class FinishBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IFinishService finishService;

    @Autowired
    private IOddjobService oddjobService;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        FinishVO finishEntity = finishService.queryDetail(billId);
        ContractEntity contractEntity  = contractService.getById(finishEntity.getContractId());

        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = finishEntity.getShouldPayTaxMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayTaxMny();
        BigDecimal settleMny = finishEntity.getShouldPayMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayMny();

        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = finishEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobTaxMny();
        BigDecimal jobMny = finishEntity.getOddjobMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobMny();

        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = finishEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOtherTaxMny();
        BigDecimal otherMny = finishEntity.getOtherMny() == null ? BigDecimal.ZERO : finishEntity.getOtherMny();

        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
//        updateWrapper.set(ContractEntity::getFinishFlag, Boolean.TRUE);
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, sumSettleTaxMny.add(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, sumSettleMny.add(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, sumOddjobSettleTaxMny.add(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, sumOddjobSettleMny.add(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, sumOtherTaxMny.add(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, sumOtherMny.add(otherMny));
        updateWrapper.eq(ContractEntity::getId, finishEntity.getContractId());
        contractService.update(contractEntity, updateWrapper, false);

//        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
//            oddjobService.updateSettleByPks(finishEntity.getFinishOddjobList().stream().map(FinishOddjobVO::getOddjobId).collect(Collectors.toList()), Boolean.TRUE);
//        }
        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
            oddjobService.updateSettleMny(finishEntity.getFinishOddjobList(), Boolean.TRUE);
        }

        finishService.costPush(BeanMapper.map(finishEntity, FinishEntity.class));

        return CommonResponse.success("审批回调合同成功！");
    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        FinishVO finishEntity = finishService.queryDetail(billId);
        ContractEntity contractEntity  = contractService.getById(finishEntity.getContractId());

        BigDecimal sumSettleTaxMny = contractEntity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleTaxMny();
        BigDecimal sumSettleMny = contractEntity.getSumSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumSettleMny();
        BigDecimal settleTaxMny = finishEntity.getShouldPayTaxMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayTaxMny();
        BigDecimal settleMny = finishEntity.getShouldPayMny() == null ? BigDecimal.ZERO : finishEntity.getShouldPayMny();

        BigDecimal sumOddjobSettleTaxMny = contractEntity.getSumOddjobSettleTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleTaxMny();
        BigDecimal sumOddjobSettleMny = contractEntity.getSumOddjobSettleMny() == null ? BigDecimal.ZERO : contractEntity.getSumOddjobSettleMny();
        BigDecimal jobTaxMny = finishEntity.getOddjobTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobTaxMny();
        BigDecimal jobMny = finishEntity.getOddjobMny() == null ? BigDecimal.ZERO : finishEntity.getOddjobMny();

        BigDecimal sumOtherTaxMny = contractEntity.getSumOtherTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherTaxMny();
        BigDecimal sumOtherMny = contractEntity.getSumOtherMny() == null ? BigDecimal.ZERO : contractEntity.getSumOtherMny();
        BigDecimal otherTaxMny = finishEntity.getOtherTaxMny() == null ? BigDecimal.ZERO : finishEntity.getOtherTaxMny();
        BigDecimal otherMny = finishEntity.getOtherMny() == null ? BigDecimal.ZERO : finishEntity.getOtherMny();

        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
//        updateWrapper.set(ContractEntity::getFinishFlag, Boolean.FALSE);
        updateWrapper.set(ContractEntity::getSumSettleTaxMny, sumSettleTaxMny.subtract(settleTaxMny));
        updateWrapper.set(ContractEntity::getSumSettleMny, sumSettleMny.subtract(settleMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleTaxMny, sumOddjobSettleTaxMny.subtract(jobTaxMny));
        updateWrapper.set(ContractEntity::getSumOddjobSettleMny, sumOddjobSettleMny.subtract(jobMny));
        updateWrapper.set(ContractEntity::getSumOtherTaxMny, sumOtherTaxMny.subtract(otherTaxMny));
        updateWrapper.set(ContractEntity::getSumOtherMny, sumOtherMny.subtract(otherMny));
        updateWrapper.eq(ContractEntity::getId, finishEntity.getContractId());
        contractService.update(contractEntity, updateWrapper, false);

//        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
//            oddjobService.updateSettleByPks(finishEntity.getFinishOddjobList().stream().map(FinishOddjobVO::getOddjobId).collect(Collectors.toList()), Boolean.FALSE);
//        }
        if(CollectionUtils.isNotEmpty(finishEntity.getFinishOddjobList())){
            oddjobService.updateSettleMny(finishEntity.getFinishOddjobList(), Boolean.FALSE);
        }

        finishService.pullCost(billId);

        return CommonResponse.success("审批回调合同成功！");
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        //TO DO 结算单是否被其他引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }

}
