/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.OddjobEntity;
import com.ejianc.business.sub.mapper.OddjobMapper;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IOddjobService;
import com.ejianc.business.sub.vo.FinishOddjobVO;
import com.ejianc.business.sub.vo.OddjobRecordDetailVO;
import com.ejianc.business.sub.vo.OddjobRecordVO;
import com.ejianc.business.sub.vo.OddjobVO;
import com.ejianc.business.sub.vo.SettleOddjobVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="OddjobServiceImpl")
public class OddjobServiceImpl
extends BaseServiceImpl<OddjobMapper, OddjobEntity>
implements IOddjobService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SUB_ODDJOB_BILL_CODE = "SUB_ODDJOB";
    @Autowired
    private IContractService contractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OddjobVO insertOrUpdate(OddjobVO oddjobVO) {
        block12: {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(oddjobVO.getContractId()));
            if (oddjobVO.getContractVersion() != null && oddjobVO.getContractVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(oddjobVO.getContractId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (version != (conVersion = oddjobVO.getContractVersion())) {
                            throw new BusinessException("\u5206\u5305\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                        }
                        break block12;
                    }
                    throw new BusinessException("\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(oddjobVO.getContractId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)oddjobVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(SUB_ODDJOB_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                oddjobVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        OddjobEntity oddjobEntity = (OddjobEntity)((Object)BeanMapper.map((Object)oddjobVO, OddjobEntity.class));
        super.saveOrUpdate((Object)oddjobEntity, false);
        return this.queryDetail(oddjobEntity.getId());
    }

    @Override
    public OddjobVO queryDetail(Long id) {
        OddjobEntity oddjobEntity = (OddjobEntity)((Object)super.selectById((Serializable)id));
        OddjobVO oddjobVO = (OddjobVO)BeanMapper.map((Object)((Object)oddjobEntity), OddjobVO.class);
        return oddjobVO;
    }

    @Override
    public CommonResponse<IPage<OddjobVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.queryPage(param, false);
        List oddjobVOList = BeanMapper.mapList((Iterable)page.getRecords(), OddjobVO.class);
        Page oddjobVOIPage = new Page();
        oddjobVOIPage.setCurrent(page.getCurrent());
        oddjobVOIPage.setRecords(oddjobVOList);
        oddjobVOIPage.setSize(page.getSize());
        oddjobVOIPage.setTotal(page.getTotal());
        oddjobVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)oddjobVOIPage);
    }

    @Override
    public CommonResponse<String> deleteByIds(List<OddjobVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public OddjobVO queryDetailAdd(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        OddjobVO oddjobVO = (OddjobVO)BeanMapper.map((Object)((Object)contractEntity), OddjobVO.class);
        oddjobVO.setBillCode(null);
        oddjobVO.setEmployeeId(null);
        oddjobVO.setEmployeeName(null);
        oddjobVO.setContractId(contractEntity.getId());
        oddjobVO.setBillState(null);
        oddjobVO.setCreateUserCode(null);
        oddjobVO.setCreateTime(null);
        oddjobVO.setUpdateUserCode(null);
        oddjobVO.setUpdateTime(null);
        oddjobVO.setId(null);
        return oddjobVO;
    }

    @Override
    public OddjobRecordVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        OddjobRecordVO oddjobRecordVO = new OddjobRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        oddjobRecordVO.setContractId(id);
        oddjobRecordVO.setFinishFlag(contractEntity.getFinishFlag());
        oddjobRecordVO.setContractTaxMny(contractTaxMny);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(OddjobEntity::getContractId, (Object)id);
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.in(OddjobEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(OddjobEntity::getOrgId, (Collection)((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        List entities = super.list((Wrapper)lambda);
        List oddjobRecordDetailVOList = BeanMapper.mapList((Iterable)entities, OddjobRecordDetailVO.class);
        BigDecimal oddjobTaxMny = BigDecimal.ZERO;
        BigDecimal settleTaxMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)oddjobRecordDetailVOList)) {
            for (OddjobRecordDetailVO ojr : oddjobRecordDetailVOList) {
                BigDecimal jobTaxMny = ojr.getJobTaxMny() == null ? BigDecimal.ZERO : ojr.getJobTaxMny();
                BigDecimal scale = contractTaxMny == BigDecimal.ZERO ? BigDecimal.ZERO : jobTaxMny.divide(contractTaxMny, 4).multiply(new BigDecimal(100));
                ojr.setScale(scale);
                oddjobTaxMny = oddjobTaxMny.add(jobTaxMny);
                BigDecimal oddjobSettleTaxMny = ojr.getOddjobSettleTaxMny() == null ? BigDecimal.ZERO : ojr.getOddjobSettleTaxMny();
                settleTaxMny = settleTaxMny.add(oddjobSettleTaxMny);
            }
        }
        oddjobRecordVO.setDetailList(oddjobRecordDetailVOList);
        oddjobRecordVO.setSumOddjobTaxMny(oddjobTaxMny);
        oddjobRecordVO.setSumOddjobSettleTaxMny(settleTaxMny);
        BigDecimal sumScale = contractTaxMny == BigDecimal.ZERO ? BigDecimal.ZERO : oddjobTaxMny.divide(contractTaxMny, 4).multiply(new BigDecimal(100));
        oddjobRecordVO.setSumScale(sumScale);
        return oddjobRecordVO;
    }

    @Override
    public void updateSettleByPks(List<Long> pks, Boolean flag) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.set(OddjobEntity::getSettleFlag, (Object)flag);
        updateWrapper.in(BaseEntity::getId, pks);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void updateSettleMnyByPks(List<SettleOddjobVO> list, Boolean flag) {
        if (null != list && list.size() > 0) {
            for (SettleOddjobVO vo : list) {
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(OddjobEntity::getSettleFlag, (Object)flag);
                updateWrapper.set(OddjobEntity::getOddjobSettleTaxMny, (Object)vo.getSettleMny());
                updateWrapper.eq(BaseEntity::getId, (Object)vo.getOddjobId());
                this.update((Wrapper)updateWrapper);
            }
        }
    }

    @Override
    public void updateSettleMny(List<FinishOddjobVO> list, Boolean flag) {
        if (null != list && list.size() > 0) {
            for (FinishOddjobVO vo : list) {
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(OddjobEntity::getSettleFlag, (Object)flag);
                updateWrapper.set(OddjobEntity::getOddjobSettleTaxMny, (Object)vo.getSettleMny());
                updateWrapper.eq(BaseEntity::getId, (Object)vo.getOddjobId());
                this.update((Wrapper)updateWrapper);
            }
        }
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage pageData = this.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), OddjobVO.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
            beans.put("records", list);
            ExcelExport.getInstance().export("oddjob-export.xlsx", beans, response);
        }
    }
}

