/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.certify.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifyregHEntity;
import com.ejianc.certify.enums.CertStatusEnum;
import com.ejianc.certify.enums.FstatusEnum;
import com.ejianc.certify.enums.YesNoEnum;
import com.ejianc.certify.mapper.CertifyregHMapper;
import com.ejianc.certify.service.ICertifTypeService;
import com.ejianc.certify.service.ICertifregBService;
import com.ejianc.certify.service.ICertifregFService;
import com.ejianc.certify.service.ICertifyregHService;
import com.ejianc.certify.service.ISocialInsuranceService;
import com.ejianc.certify.vo.CertifregBVO;
import com.ejianc.certify.vo.CertifregFVO;
import com.ejianc.certify.vo.CertifyregHVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="certifyregHService")
public class CertifyregHServiceImpl
extends BaseServiceImpl<CertifyregHMapper, CertifyregHEntity>
implements ICertifyregHService {
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;
    @Resource
    private IDefdocApi defdocApi;
    @Autowired
    private ICertifregBService bService;
    @Autowired
    private ICertifregFService fService;
    @Autowired
    private ICertifTypeService tservice;
    @Autowired
    private ISocialInsuranceService sservice;

    @Override
    public CommonResponse<IPage<CertifregBVO>> queryBPageByHParm(QueryParam param) {
        IPage page = this.bService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertifregBVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @Override
    public CommonResponse<IPage<CertifregFVO>> queryFPageByHParm(QueryParam param) {
        IPage page = this.fService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertifregFVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @Override
    public Map<String, Object> excelExport(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("pkOrg", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, CertifyregHVO.class);
        return this.exportTranslate(vos);
    }

    private Map<String, Object> exportTranslate(List<CertifyregHVO> vos) {
        for (CertifyregHVO vo : vos) {
            CommonResponse org = this.iOrgApi.getOneById(vo.getPkOrg());
            this.getRespData(org, true, "\u67e5\u8be2\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:" + org.getMsg());
            vo.setPkOrgName(((OrgVO)org.getData()).getName());
            CommonResponse applyerorg = this.iOrgApi.getOneById(vo.getApplyerorg());
            this.getRespData(applyerorg, true, "\u67e5\u8be2\u53d1\u8d77\u4eba\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:" + applyerorg.getMsg());
            vo.setApplyerorgName(((OrgVO)applyerorg.getData()).getName());
            CommonResponse vcertcorp = this.iOrgApi.getOneById(vo.getPkVcertcorp());
            this.getRespData(vcertcorp, true, "\u67e5\u8be2\u6301\u8bc1\u533a\u57df\u5f02\u5e38:" + vcertcorp.getMsg());
            vo.setPkVcertcorpName(((OrgVO)vcertcorp.getData()).getName());
            CommonResponse certpsn = this.iEmplApi.getById(vo.getPkCertpsn());
            this.getRespData(certpsn, true, "\u67e5\u8be2\u6301\u8bc1\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:" + certpsn.getMsg());
            vo.setPkCertpsnName(((EmployeeVO)certpsn.getData()).getName());
            CommonResponse receiver = this.iEmplApi.getById(vo.getReceiver());
            this.getRespData(receiver, true, "\u67e5\u8be2\u63a5\u6536\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:" + receiver.getMsg());
            vo.setReceiverName(((EmployeeVO)receiver.getData()).getName());
            CommonResponse applyer = this.iEmplApi.getById(vo.getApplyer());
            this.getRespData(applyer, true, "\u67e5\u8be2\u53d1\u8d77\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:" + applyer.getMsg());
            vo.setApplyerName(((EmployeeVO)applyer.getData()).getName());
            CommonResponse yjdw = this.defdocApi.getDefDocById(vo.getPkYjdw());
            this.getRespData(yjdw, true, "\u67e5\u8be2\u5f15\u8fdb\u5355\u4f4d\u4fe1\u606f\u5f02\u5e38:" + yjdw.getMsg());
            vo.setPkYjdwName(((DefdocDetailVO)yjdw.getData()).getName());
            CommonResponse sbzt = this.defdocApi.getDefDocById(vo.getPkSbzt());
            this.getRespData(sbzt, true, "\u67e5\u8be2\u793e\u4fdd\u4e3b\u4f53\u4fe1\u606f\u5f02\u5e38:" + sbzt.getMsg());
            vo.setPkSbztName(((DefdocDetailVO)sbzt.getData()).getName());
            Optional.of(this.tservice.selectById(vo.getPkCertiftype())).ifPresent(t -> vo.setPkCertiftypeName(t.getName()));
            Optional.of(vo.getPkGlzcz()).ifPresent(glzcz -> Optional.of(this.selectById((Serializable)glzcz)).ifPresent(t -> vo.setPkGlzczName(t.getName())));
            Optional.of(vo.getPkGlzyz()).ifPresent(glzyz -> Optional.of(this.selectById((Serializable)glzyz)).ifPresent(t -> vo.setPkGlzyzName(t.getName())));
            Integer certStatus = Optional.of(vo.getCertStatus()).orElse(0);
            vo.setCertStatusName(CertStatusEnum.findDescByCode(certStatus));
            Optional.of(vo.getIsZyzj()).ifPresent(t -> vo.setIsZyzj(YesNoEnum.findDescByCode(t)));
            Optional.of(vo.getIsDzzj()).ifPresent(t -> vo.setIsDzzj(YesNoEnum.findDescByCode(t)));
            Optional.of(vo.getYjIsrecevie()).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findDescByCode(t)));
            Optional.of(vo.getApplyisusemore()).ifPresent(t -> vo.setApplyisusemore(YesNoEnum.findDescByCode(t)));
            Optional.of(vo.getApplyiscrosarea()).ifPresent(t -> vo.setApplyiscrosarea(YesNoEnum.findDescByCode(t)));
            Optional.of(vo.getApplyisinstore()).ifPresent(t -> vo.setApplyisinstore(YesNoEnum.findDescByCode(t)));
            Optional.of(vo.getApplyisreg()).ifPresent(t -> vo.setApplyisreg(YesNoEnum.findDescByCode(t)));
            Optional.of(vo.getApplyisuse()).ifPresent(t -> vo.setApplyisuse(YesNoEnum.findDescByCode(t)));
            Optional.of(vo.getApplyispleg()).ifPresent(t -> vo.setApplyispleg(YesNoEnum.findDescByCode(t)));
            Optional.of(vo.getApplyislock()).ifPresent(t -> vo.setApplyislock(YesNoEnum.findDescByCode(t)));
            Optional.of(vo.getApplyischanging()).ifPresent(t -> vo.setApplyischanging(YesNoEnum.findDescByCode(t)));
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", vos);
        return beans;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @Override
    public CommonResponse<JSONObject> excelImport(Map<String, MultipartFile> fileMap) {
        Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, MultipartFile> entity = iterator.next();
            MultipartFile file = entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                return CommonResponse.error((String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
            List importList = ExcelReader.readExcel((MultipartFile)file);
            return CommonResponse.success((Object)this.importTranslate(importList));
        }
        return CommonResponse.error((String)"\u6ca1\u6709\u6536\u5230\u5bfc\u5165\u6587\u4ef6\uff01");
    }

    private JSONObject importTranslate(List<List<String>> importList) {
        ArrayList<CertifyregHVO> successList = new ArrayList<CertifyregHVO>();
        ArrayList<CertifyregHVO> failList = new ArrayList<CertifyregHVO>();
        for (int i = 0; i < importList.size(); ++i) {
            OrgVO orgQuery = new OrgVO();
            StringJoiner errMsg = new StringJoiner(";");
            CertifyregHVO vo = new CertifyregHVO();
            List<String> row = importList.get(i);
            CommonResponse empl = this.iEmplApi.getByEmpmloyeeCode("EMP" + row.get(0));
            if (empl.isSuccess()) {
                vo.setPkCertpsn(((EmployeeVO)empl.getData()).getId());
            } else {
                errMsg.add("\u6301\u8bc1\u4eba-" + empl.getMsg());
            }
            vo.setPsnPhone(row.get(1));
            vo.setCardId(row.get(2));
            vo.setPkSbzt(this.sservice.getSubIdByName(row.get(3)));
            orgQuery.setName(row.get(4));
            CommonResponse pkVcertcorp = this.iOrgApi.findOneByOrgVO(orgQuery);
            if (pkVcertcorp.isSuccess()) {
                vo.setPkVcertcorp(((OrgVO)pkVcertcorp.getData()).getId());
            } else {
                errMsg.add("\u6301\u8bc1\u533a\u57df-" + pkVcertcorp.getMsg());
            }
            vo.setApplyprofessor(row.get(5));
            vo.setPkCertiftype(this.tservice.getIdByName(row.get(6)));
            String certStatusName = Optional.of(row.get(7)).orElse(CertStatusEnum.INVALID.getDesc());
            vo.setCertStatus(CertStatusEnum.findCodeByName(certStatusName));
            vo.setCertifcode(row.get(8));
            orgQuery.setName(row.get(9));
            CommonResponse pkOrg = this.iOrgApi.findOneByOrgVO(orgQuery);
            if (pkOrg.isSuccess()) {
                vo.setPkOrg(((OrgVO)pkOrg.getData()).getId());
            } else {
                errMsg.add("\u7ba1\u7406\u7ec4\u7ec7-" + pkOrg.getMsg());
            }
            vo.setPkYjdw(this.sservice.getSubIdByName(row.get(11)));
            vo.setVgrantcertunit(row.get(12));
            vo.setApplyregdate(row.get(13));
            vo.setReceivedate(row.get(14));
            CommonResponse receiver = this.iEmplApi.getByEmpmloyeeCode("EMP" + row.get(15));
            if (receiver.isSuccess()) {
                vo.setReceiver(((EmployeeVO)receiver.getData()).getId());
            } else {
                errMsg.add("\u63a5\u6536\u4eba-" + receiver.getMsg());
            }
            vo.setEffectTime(row.get(16));
            vo.setExpireTime(row.get(17));
            vo.setExpireReason(row.get(18));
            vo.setDgrantcertdate(row.get(19));
            vo.setValidbegindate(row.get(20));
            vo.setValidbegindate(row.get(21));
            vo.setIsZyzj(YesNoEnum.findCodeByName(row.get(24)));
            vo.setApplydate(row.get(25));
            vo.setVoperscope(row.get(26));
            CommonResponse applyer = this.iEmplApi.getByEmpmloyeeCode("EMP" + row.get(27));
            if (applyer.isSuccess()) {
                vo.setApplyer(((EmployeeVO)applyer.getData()).getId());
            } else {
                errMsg.add("\u53d1\u8d77\u4eba-" + applyer.getMsg());
            }
            orgQuery.setName(row.get(28));
            CommonResponse applyerOrg = this.iOrgApi.findOneByOrgVO(orgQuery);
            if (applyerOrg.isSuccess()) {
                vo.setApplyerorg(((OrgVO)applyerOrg.getData()).getId());
            } else {
                errMsg.add("\u53d1\u8d77\u4eba\u7ec4\u7ec7-" + applyerOrg.getMsg());
            }
            Optional.of(row.get(29)).ifPresent(t -> vo.setIsDzzj(YesNoEnum.findCodeByName(t)));
            Optional.of(row.get(30)).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findCodeByName(t)));
            Optional.of(row.get(31)).ifPresent(t -> vo.setApplyisusemore(YesNoEnum.findCodeByName(t)));
            Optional.of(row.get(32)).ifPresent(t -> vo.setApplyiscrosarea(YesNoEnum.findCodeByName(t)));
            Optional.of(row.get(33)).ifPresent(t -> vo.setApplyisinstore(YesNoEnum.findCodeByName(t)));
            Optional.of(row.get(34)).ifPresent(t -> vo.setApplyisreg(YesNoEnum.findCodeByName(t)));
            Optional.of(row.get(35)).ifPresent(t -> vo.setApplyisuse(YesNoEnum.findCodeByName(t)));
            Optional.of(row.get(36)).ifPresent(t -> vo.setApplyispleg(YesNoEnum.findCodeByName(t)));
            Optional.of(row.get(37)).ifPresent(t -> vo.setApplyislock(YesNoEnum.findCodeByName(t)));
            if (errMsg.length() > 0) {
                vo.setImportError(errMsg.toString());
                failList.add(vo);
                continue;
            }
            vo.setFstatusflag(FstatusEnum.FREE.getCode());
            successList.add(vo);
        }
        JSONObject json = new JSONObject();
        json.put("success", successList);
        json.put("fail", failList);
        return json;
    }
}

