package com.ejianc.certify.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.certify.vo.CertifregBVO;
import com.ejianc.certify.vo.CertifregFVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.certify.bean.CertifyregHEntity;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import java.util.Map;

/**
 * 证照登记单-表头
 * 
 * @author generator
 * 
 */
public interface ICertifyregHService extends IBaseService<CertifyregHEntity> {

    /**
     * @description    根据证照登记单参数分页查询变更记录
     * @author yxm
     * @date 2022/5/13
     * @param param
     */
    CommonResponse<IPage<CertifregBVO>> queryBPageByHParm(QueryParam param);

    /**
     * @description    根据证照登记单参数分页查询基本补贴调整额
     * @author yxm
     * @date 2022/5/13
     * @param param
     */
    CommonResponse<IPage<CertifregFVO>> queryFPageByHParm(QueryParam param);

    /**
     * @description    excel导出
     * @author yxm
     * @date 2022/5/13
     * @param param
     */
    public Map<String, Object> excelExport(QueryParam param);

    /**
     * @description    excel导出
     * @author yxm
     * @date 2022/5/13
     * @param fileMap
     */
    public CommonResponse<JSONObject> excelImport(Map<String, MultipartFile> fileMap);
}
