package com.ejianc.certify.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifregBEntity;
import com.ejianc.certify.bean.CertifregFEntity;
import com.ejianc.certify.enums.BillStatusEnum;
import com.ejianc.certify.enums.CertStatusEnum;
import com.ejianc.certify.enums.YesNoEnum;
import com.ejianc.certify.service.*;
import com.ejianc.certify.vo.CertifregBVO;
import com.ejianc.certify.vo.CertifregFVO;
import com.ejianc.certify.vo.CertifyregHVO;
import com.ejianc.certify.vo.SocialInsuranceVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.CertifyregHMapper;
import com.ejianc.certify.bean.CertifyregHEntity;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

/**
 * 证照登记单-表头
 *
 * @author generator
 *
 */
@Service("certifyregHService")
public class CertifyregHServiceImpl extends BaseServiceImpl<CertifyregHMapper, CertifyregHEntity> implements ICertifyregHService{
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;
    @Resource
    private IDefdocApi defdocApi;


    @Autowired
    private ICertifregBService bService;
    @Autowired
    private ICertifregFService fService;
    @Autowired
    private ICertifTypeService tservice;
    @Autowired
    private ISocialInsuranceService sservice;

    private static final String  PKBILLTYPE = "ZJ001";



    /**
     * @description    根据证照登记单参数分页查询变更记录
     * @author yxm
     * @date 2022/5/13
     * @param param
     */
    @Override
    public CommonResponse<IPage<CertifregBVO>> queryBPageByHParm(QueryParam param) {
        IPage<CertifregBEntity> page = bService.queryPage(param,false);
        IPage<CertifregBVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertifregBVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @description    根据证照登记单参数分页查询基本补贴调整额
     * @author yxm
     * @date 2022/5/13
     * @param param
     */
    @Override
    public CommonResponse<IPage<CertifregFVO>> queryFPageByHParm(QueryParam param) {
        IPage<CertifregFEntity> page = fService.queryPage(param,false);
        IPage<CertifregFVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertifregFVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @Override
    public Map<String, Object> excelExport(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("pkOrg",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CertifyregHEntity> list = queryList(param);
        //todo:字段翻译等等
        List<CertifyregHVO> vos = BeanMapper.mapList(list, CertifyregHVO.class);
        return exportTranslate(vos);
    }

    private Map<String, Object> exportTranslate(List<CertifyregHVO> vos) {
        for (CertifyregHVO vo : vos) {
            CommonResponse<OrgVO> org = iOrgApi.getOneById(vo.getPkOrg());
            getRespData(org,true,"查询管理组织信息异常:"+org.getMsg());
            vo.setPkOrgName(org.getData().getName());

            CommonResponse<OrgVO> applyerorg = iOrgApi.getOneById(vo.getApplyerorg());
            getRespData(applyerorg,true,"查询发起人组织信息异常:"+applyerorg.getMsg());
            vo.setApplyerorgName(applyerorg.getData().getName());

            CommonResponse<OrgVO> vcertcorp = iOrgApi.getOneById(vo.getPkVcertcorp());
            getRespData(vcertcorp,true,"查询持证区域异常:"+vcertcorp.getMsg());
            vo.setPkVcertcorpName(vcertcorp.getData().getName());

            CommonResponse<EmployeeVO> certpsn = iEmplApi.getById(vo.getPkCertpsn());
            getRespData(certpsn,true,"查询持证人员信息异常:"+certpsn.getMsg());
            vo.setPkCertpsnName(certpsn.getData().getName());

            CommonResponse<EmployeeVO> receiver = iEmplApi.getById(vo.getReceiver());
            getRespData(receiver,true,"查询接收人员信息异常:"+receiver.getMsg());
            vo.setReceiverName(receiver.getData().getName());

            CommonResponse<EmployeeVO> applyer = iEmplApi.getById(vo.getApplyer());
            getRespData(applyer,true,"查询发起人员信息异常:"+applyer.getMsg());
            vo.setApplyerName(applyer.getData().getName());

            CommonResponse<DefdocDetailVO> yjdw = defdocApi.getDefDocById(vo.getPkYjdw());
            getRespData(yjdw,true,"查询引进单位信息异常:"+yjdw.getMsg());
            vo.setPkYjdwName(yjdw.getData().getName());

            CommonResponse<DefdocDetailVO> sbzt = defdocApi.getDefDocById(vo.getPkSbzt());
            getRespData(sbzt,true,"查询社保主体信息异常:"+sbzt.getMsg());
            vo.setPkSbztName(sbzt.getData().getName());

            Optional.of(tservice.selectById(vo.getPkCertiftype())).ifPresent(t -> vo.setPkCertiftypeName(t.getName()));
            Optional.of(vo.getPkGlzcz()).ifPresent(glzcz -> {
                Optional.of(selectById(glzcz)).ifPresent(t -> vo.setPkGlzczName(t.getName()));
            });
            Optional.of(vo.getPkGlzyz()).ifPresent(glzyz -> {
                Optional.of(selectById(glzyz)).ifPresent(t -> vo.setPkGlzyzName(t.getName()));
            });

            Integer certStatus = Optional.of(vo.getCertStatus()).orElse(0);
            vo.setCertStatusName(CertStatusEnum.findDesc(certStatus));
            Optional.of(vo.getIsZyzj()).ifPresent(t -> vo.setIsZyzj(YesNoEnum.findDesc(t)));
            Optional.of(vo.getIsDzzj()).ifPresent(t -> vo.setIsDzzj(YesNoEnum.findDesc(t)));
            Optional.of(vo.getYjIsrecevie()).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findDesc(t)));
            Optional.of(vo.getApplyisusemore()).ifPresent(t -> vo.setApplyisusemore(YesNoEnum.findDesc(t)));
            Optional.of(vo.getApplyiscrosarea()).ifPresent(t -> vo.setApplyiscrosarea(YesNoEnum.findDesc(t)));
            Optional.of(vo.getApplyisinstore()).ifPresent(t -> vo.setApplyisinstore(YesNoEnum.findDesc(t)));
            Optional.of(vo.getApplyisreg()).ifPresent(t -> vo.setApplyisreg(YesNoEnum.findDesc(t)));
            Optional.of(vo.getApplyisuse()).ifPresent(t -> vo.setApplyisuse(YesNoEnum.findDesc(t)));
            Optional.of(vo.getApplyispleg()).ifPresent(t -> vo.setApplyispleg(YesNoEnum.findDesc(t)));
            Optional.of(vo.getApplyislock()).ifPresent(t -> vo.setApplyislock(YesNoEnum.findDesc(t)));
            Optional.of(vo.getApplyischanging()).ifPresent(t -> vo.setApplyischanging(YesNoEnum.findDesc(t)));
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        return beans;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @Override
    public CommonResponse<JSONObject> excelImport(Map<String, MultipartFile> fileMap) {
        //todo:添加excel导入代码
        List<CertifyregHVO> successList = new ArrayList<>();
        List<CertifyregHVO> failList = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            MultipartFile file = entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                return CommonResponse.error("文件类型不正确");
            }

            List<List<String>> importList = ExcelReader.readExcel(file);
            Map<String, Object> importResult = importTranslate(importList);
            if ((boolean)importResult.get("errFlag")) {
                failList.addAll((List<CertifyregHVO>)importResult.get("list"));
            }else{
                successList.addAll((List<CertifyregHVO>)importResult.get("list"));
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", failList);
        return CommonResponse.success(json);
    }

    private Map<String, Object> importTranslate(List<List<String>> importList) {
        List<CertifyregHVO> successList = new ArrayList<>();
        List<CertifyregHVO> failList = new ArrayList<>();
        Map<String,Object> result = new HashMap<>();
        boolean errFlag = false;
        for (int i = 0; i < importList.size(); i++) {
            OrgVO orgQuery = new OrgVO();
            StringJoiner errMsg = new StringJoiner(";");
            CertifyregHVO vo = new CertifyregHVO();
            List<String> row = importList.get(i);

            //持证人
            CommonResponse<EmployeeVO> empl = iEmplApi.getByEmpmloyeeCode("EMP" + row.get(0));
            if (empl.isSuccess()) {
                vo.setPkCertpsn(empl.getData().getId());
            }else{
                errFlag = true;
                errMsg.add("持证人-" + empl.getMsg());
            }
            vo.setPsnPhone(row.get(1));
            vo.setCardId(row.get(2));
            vo.setPkSbzt(sservice.getSubIdByName(row.get((3))).getPkSbzt());
            //持证区域
            orgQuery.setName(row.get(4));
            CommonResponse<OrgVO> pkVcertcorp = iOrgApi.findOneByOrgVO(orgQuery);
            if (pkVcertcorp.isSuccess()) {
                vo.setPkVcertcorp(pkVcertcorp.getData().getId());
            }else{
                errFlag = true;
                errMsg.add("持证区域-" + pkVcertcorp.getMsg());
            }
            vo.setApplyprofessor(row.get(5));
            Long pkCertiftype = tservice.getIdByName(row.get(6));
            if (pkCertiftype == null || pkCertiftype == 0) {
                errFlag = true;
                errMsg.add("证照名称-没有找到对应的证照类别");
            }else{
                vo.setPkCertiftype(pkCertiftype);
            }

            //证照状态
            String certStatusName = Optional.of(row.get(7)).orElse(CertStatusEnum.INVALID.getDesc());
            vo.setCertStatus(CertStatusEnum.findCode(certStatusName));
            vo.setCertifcode(row.get(8));
            //管理组织
            orgQuery.setName(row.get(9));
            CommonResponse<OrgVO> pkOrg = iOrgApi.findOneByOrgVO(orgQuery);
            if (pkOrg.isSuccess()) {
                vo.setPkOrg(pkOrg.getData().getId());
            }else{
                errFlag = true;
                errMsg.add("管理组织-" + pkOrg.getMsg());
            }
            //todo 管理部门-10

            //引进单位和资质类别
            SocialInsuranceVO yjdw = sservice.getSubIdByName(row.get((11)));
            vo.setPkYjdw(yjdw.getPkSbzt());
            vo.setApplyorgtype(yjdw.getSbztType());

            vo.setVgrantcertunit(row.get(12));
            vo.setApplyregdate(row.get(13));
            vo.setReceivedate(row.get(14));
            //接收人
            CommonResponse<EmployeeVO> receiver = iEmplApi.getByEmpmloyeeCode("EMP" + row.get(15));
            if (receiver.isSuccess()) {
                vo.setReceiver(receiver.getData().getId());
            }else{
                errFlag = true;
                errMsg.add("接收人-" + receiver.getMsg());
            }
            vo.setEffectTime(row.get(16));
            vo.setExpireTime(row.get(17));
            vo.setExpireReason(row.get(18));
            vo.setDgrantcertdate(row.get(19));
            vo.setValidbegindate(row.get(20));
            vo.setValidbegindate(row.get(21));
            //todo 关联执业证件-22
            if (StringUtils.isNotBlank(row.get(22))) {
                Long pkGlzyzId = tservice.getIdByName(row.get(22));
                if ( pkGlzyzId != null || pkGlzyzId != 0) {
                    QueryWrapper<CertifyregHEntity> pkGlzyzQuery = new QueryWrapper<>();
                    pkGlzyzQuery.eq("pk_certpsn", vo.getPkCertpsn());
                    pkGlzyzQuery.eq("pk_ertiftype", pkGlzyzId);
                    CertifyregHEntity pkGlzyz = getOne(pkGlzyzQuery);
                    if (pkGlzyz != null) {
                        vo.setPkGlzyz(pkGlzyz.getId());
                    }else{
                        errFlag = true;
                        errMsg.add("关联执业证件-没有对应的执业证件" );
                    }
                }else{
                    errFlag = true;
                    errMsg.add("关联执业证件-没有对应的证照类别" );
                }
            }

            //todo 关联注册证-23
            if (StringUtils.isNotBlank(row.get(23))) {
                Long pkGlzczId = tservice.getIdByName(row.get(23));
                if ( pkGlzczId != null || pkGlzczId != 0) {
                    QueryWrapper<CertifyregHEntity> pkGlzczQuery = new QueryWrapper<>();
                    pkGlzczQuery.eq("pk_certpsn", vo.getPkCertpsn());
                    pkGlzczQuery.eq("pk_ertiftype", pkGlzczId);
                    CertifyregHEntity pkGlzcz = getOne(pkGlzczQuery);
                    if (pkGlzcz != null) {
                        vo.setPkGlzcz(pkGlzcz.getId());
                    }else{
                        errFlag = true;
                        errMsg.add("关联注册证-没有对应的注册证" );
                    }
                }else{
                    errFlag = true;
                    errMsg.add("关联注册证-没有对应的注册证" );
                }
            }

            vo.setIsZyzj(YesNoEnum.findCode(row.get(24)));
            vo.setApplydate(row.get(25));
            vo.setVoperscope(row.get(26));
            //发起人
            CommonResponse<EmployeeVO> applyer = iEmplApi.getByEmpmloyeeCode("EMP" + row.get(27));
            if (applyer.isSuccess()) {
                vo.setApplyer(applyer.getData().getId());
            }else{
                errFlag = true;
                errMsg.add("发起人-" + applyer.getMsg());
            }
            //发起人组织
            orgQuery.setName(row.get(28));
            CommonResponse<OrgVO> applyerOrg = iOrgApi.findOneByOrgVO(orgQuery);
            if (applyerOrg.isSuccess()) {
                vo.setApplyerorg(applyerOrg.getData().getId());
            }else{
                errFlag = true;
                errMsg.add("发起人组织-" + applyerOrg.getMsg());
            }

            Optional.of(row.get(29)).ifPresent(t -> vo.setIsDzzj(YesNoEnum.findCode(t)));
            Optional.of(row.get(30)).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findCode(t)));
            Optional.of(row.get(31)).ifPresent(t -> vo.setApplyisusemore(YesNoEnum.findCode(t)));
            Optional.of(row.get(32)).ifPresent(t -> vo.setApplyiscrosarea(YesNoEnum.findCode(t)));
            Optional.of(row.get(33)).ifPresent(t -> vo.setApplyisinstore(YesNoEnum.findCode(t)));
            Optional.of(row.get(34)).ifPresent(t -> vo.setApplyisreg(YesNoEnum.findCode(t)));
            Optional.of(row.get(35)).ifPresent(t -> vo.setApplyisuse(YesNoEnum.findCode(t)));
            Optional.of(row.get(36)).ifPresent(t -> vo.setApplyispleg(YesNoEnum.findCode(t)));
            Optional.of(row.get(37)).ifPresent(t -> vo.setApplyislock(YesNoEnum.findCode(t)));

            DateFormater date = DateFormater.getInstance(DateFormater.getCurrentDate(), 8);
            vo.setDbilldate(date.format(DateFormater.SHORT_FORMAT));
            vo.setPkBilltype(PKBILLTYPE);

            if (errMsg.length() > 0) {
                vo.setErrorMessage("excel文档中第" + (i+2) + "行数据异常:" +errMsg.toString());
                failList.add(vo);
            }else{
                vo.setFstatusflag(BillStatusEnum.FREE.getId());
                successList.add(vo);
            }
        }
        result.put("errFlag", errFlag);
        if (errFlag) {
            result.put("list", failList);
        }else{
            result.put("list", successList);
        }
        return result;
    }
}
