package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.vo.CorpApplyBVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.certify.mapper.CorpApplyBMapper;
import com.ejianc.certify.bean.CorpApplyBEntity;
import com.ejianc.certify.service.ICorpApplyBService;

/**
 * 证件借用申请-表体
 * 
 * @author generator
 * 
 */
@Service("corpApplyBService")
public class CorpApplyBServiceImpl extends BaseServiceImpl<CorpApplyBMapper, CorpApplyBEntity> implements ICorpApplyBService{
    @Autowired
    private ICorpApplyBService bService;

    @Override
    public CommonResponse<IPage<CorpApplyBVO>> queryBPageByHParm(QueryParam param) {
        IPage<CorpApplyBEntity> page = bService.queryPage(param,false);
        IPage<CorpApplyBVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CorpApplyBVO.class));

        return CommonResponse.success("查询明细数据成功！",pageData);
    }
}
