package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.LendresBEntity;
import com.ejianc.certify.mapper.LendresBMapper;
import com.ejianc.certify.service.ILendresBService;
import com.ejianc.certify.vo.LendresBVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 公司借证归还-表体
 * 
 * @author generator
 * 
 */
@Service("lendresBService")
public class LendresBServiceImpl extends BaseServiceImpl<LendresBMapper, LendresBEntity> implements ILendresBService{

    @Override
    public CommonResponse<IPage<LendresBVO>> queryBPageByHParm(QueryParam param) {
        IPage<LendresBEntity> page = this.queryPage(param,false);
        IPage<LendresBVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LendresBVO.class));

        return CommonResponse.success("查询明细数据成功！",pageData);
    }
}
