/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifyChangeHEntity;
import com.ejianc.certify.enums.CertStatusEnum;
import com.ejianc.certify.enums.ChangTypeEnum;
import com.ejianc.certify.enums.YesNoEnum;
import com.ejianc.certify.mapper.CertifyChangeHMapper;
import com.ejianc.certify.service.ICertifChangeFService;
import com.ejianc.certify.service.ICertifTypeService;
import com.ejianc.certify.service.ICertifyChangeHService;
import com.ejianc.certify.service.ICertifyregHService;
import com.ejianc.certify.vo.CertifChangeFVO;
import com.ejianc.certify.vo.CertifyChangeHVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="certifyChangeHService")
public class CertifyChangeHServiceImpl
extends BaseServiceImpl<CertifyChangeHMapper, CertifyChangeHEntity>
implements ICertifyChangeHService {
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;
    @Resource
    private IDefdocApi defdocApi;
    @Resource
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICertifTypeService tservice;
    @Autowired
    private ICertifyregHService hService;
    @Autowired
    private ICertifChangeFService changeFService;

    private void checkRespData(CommonResponse<?> resp, boolean isMustSuc, String title, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        if (Objects.isNull(resp.getData())) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
        if (resp.getData() instanceof List && ListUtil.isEmpty((List)((List)resp.getData()))) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
        if (resp.getData() instanceof IPage && ListUtil.isEmpty((List)((IPage)resp.getData()).getRecords())) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
    }

    @Override
    public Map<String, Object> excelExport(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("pkOrg", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, CertifyChangeHVO.class);
        return this.exportTranslate(vos);
    }

    private Map<String, Object> exportTranslate(List<CertifyChangeHVO> vos) {
        for (CertifyChangeHVO vo : vos) {
            CommonResponse org = this.iOrgApi.getOneById(vo.getPkOrg());
            this.checkRespData(org, true, "\u67e5\u8be2\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:", org.getMsg());
            vo.setPkOrgName(((OrgVO)org.getData()).getName());
            CommonResponse applyerorg = this.iOrgApi.getOneById(vo.getApplyerorg());
            this.checkRespData(applyerorg, true, "\u67e5\u8be2\u53d1\u8d77\u4eba\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:", applyerorg.getMsg());
            vo.setApplyerorgName(((OrgVO)applyerorg.getData()).getName());
            CommonResponse vcertcorp = this.iOrgApi.getOneById(vo.getPkVcertcorp());
            this.checkRespData(vcertcorp, true, "\u67e5\u8be2\u6301\u8bc1\u533a\u57df\u5f02\u5e38:", vcertcorp.getMsg());
            vo.setPkVcertcorpName(((OrgVO)vcertcorp.getData()).getName());
            CommonResponse certpsn = this.iEmplApi.getById(vo.getPkCertpsn());
            this.checkRespData(certpsn, true, "\u67e5\u8be2\u6301\u8bc1\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:", certpsn.getMsg());
            vo.setPkCertpsnName(((EmployeeVO)certpsn.getData()).getName());
            CommonResponse receiver = this.iEmplApi.getById(vo.getReceiver());
            this.checkRespData(receiver, true, "\u67e5\u8be2\u63a5\u6536\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:", receiver.getMsg());
            vo.setReceiverName(((EmployeeVO)receiver.getData()).getName());
            CommonResponse applyer = this.iEmplApi.getById(vo.getApplyer());
            this.checkRespData(applyer, true, "\u67e5\u8be2\u53d1\u8d77\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:", applyer.getMsg());
            vo.setApplyerName(((EmployeeVO)applyer.getData()).getName());
            CommonResponse yjdw = this.defdocApi.getDefDocById(vo.getPkYjdw());
            this.checkRespData(yjdw, true, "\u67e5\u8be2\u5f15\u8fdb\u5355\u4f4d\u4fe1\u606f\u5f02\u5e38:", yjdw.getMsg());
            vo.setPkYjdwName(((DefdocDetailVO)yjdw.getData()).getName());
            CommonResponse sbzt = this.defdocApi.getDefDocById(vo.getPkSbzt());
            this.checkRespData(sbzt, true, "\u67e5\u8be2\u793e\u4fdd\u4e3b\u4f53\u4fe1\u606f\u5f02\u5e38:", sbzt.getMsg());
            vo.setPkSbztName(((DefdocDetailVO)sbzt.getData()).getName());
            Optional.ofNullable(this.tservice.selectById(vo.getPkCertiftype())).ifPresent(t -> vo.setPkCertiftypeName(t.getName()));
            Optional.ofNullable(vo.getPkGlzcz()).ifPresent(glzcz -> Optional.ofNullable(this.hService.selectById((Serializable)glzcz)).ifPresent(t -> vo.setPkGlzczName(t.getName())));
            Optional.ofNullable(vo.getPkGlzyz()).ifPresent(glzyz -> Optional.ofNullable(this.hService.selectById((Serializable)glzyz)).ifPresent(t -> vo.setPkGlzyzName(t.getName())));
            String certStatus = Optional.ofNullable(vo.getCertStatus()).orElse("0");
            vo.setCertStatusName(CertStatusEnum.findDesc((String)certStatus));
            Optional.ofNullable(vo.getIsZyzj()).ifPresent(t -> vo.setIsZyzj(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getIsDzzj()).ifPresent(t -> vo.setIsDzzj(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getYjIsrecevie()).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyisusemore()).ifPresent(t -> vo.setApplyisusemore(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyiscrosarea()).ifPresent(t -> vo.setApplyiscrosarea(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyisinstore()).ifPresent(t -> vo.setApplyisinstore(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyisreg()).ifPresent(t -> vo.setApplyisreg(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyisuse()).ifPresent(t -> vo.setApplyisuse(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyispleg()).ifPresent(t -> vo.setApplyispleg(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyislock()).ifPresent(t -> vo.setApplyislock(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getApplyischanging()).ifPresent(t -> vo.setApplyischanging(YesNoEnum.findDesc((String)t)));
            Optional.ofNullable(vo.getChangeType()).ifPresent(t -> vo.setChangeType(ChangTypeEnum.findDesc((String)t)));
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", vos);
        return beans;
    }

    @Override
    public CommonResponse<IPage<CertifChangeFVO>> queryFPageByHParm(QueryParam param) {
        IPage page = this.changeFService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertifChangeFVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

