/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifySpecialReqEntity;
import com.ejianc.certify.enums.BillStatusEnum;
import com.ejianc.certify.mapper.CertifySpecialReqMapper;
import com.ejianc.certify.service.ICertifySpecialReqBService;
import com.ejianc.certify.service.ICertifySpecialReqService;
import com.ejianc.certify.vo.CertifySpecialReqBVO;
import com.ejianc.certify.vo.CertifySpecialReqVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="certifySpecialReqService")
public class CertifySpecialReqServiceImpl
extends BaseServiceImpl<CertifySpecialReqMapper, CertifySpecialReqEntity>
implements ICertifySpecialReqService {
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;
    @Autowired
    private ICertifySpecialReqBService bservice;

    private void checkRespData(CommonResponse<?> resp, boolean isMustSuc, String title, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? title + errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        if (Objects.isNull(resp.getData())) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
        if (resp.getData() instanceof List && ListUtil.isEmpty((List)((List)resp.getData()))) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
        if (resp.getData() instanceof IPage && ListUtil.isEmpty((List)((IPage)resp.getData()).getRecords())) {
            throw new BusinessException(title + "\u67e5\u8be2\u4e0d\u5230\u6570\u636e!");
        }
    }

    @Override
    public Map<String, Object> excelExport(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("pkOrg", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, CertifySpecialReqVO.class);
        return this.exportTranslate(vos);
    }

    private Map<String, Object> exportTranslate(List<CertifySpecialReqVO> vos) {
        for (CertifySpecialReqVO vo : vos) {
            CommonResponse org = this.iOrgApi.getOneById(vo.getPkOrg());
            this.checkRespData(org, true, "\u67e5\u8be2\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:", org.getMsg());
            vo.setPkOrgName(((OrgVO)org.getData()).getName());
            CommonResponse applyer = this.iEmplApi.getById(vo.getApplyer());
            this.checkRespData(applyer, true, "\u67e5\u8be2\u53d1\u8d77\u4eba\u5458\u4fe1\u606f\u5f02\u5e38:", applyer.getMsg());
            vo.setApplyerName(((EmployeeVO)applyer.getData()).getName());
            CommonResponse applyerorg = this.iOrgApi.getOneById(vo.getApplyerorg());
            this.checkRespData(applyerorg, true, "\u67e5\u8be2\u53d1\u8d77\u4eba\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38:", applyerorg.getMsg());
            vo.setApplyerorgName(((OrgVO)applyerorg.getData()).getName());
            Optional.ofNullable(vo.getVbusitype()).ifPresent(type -> {
                switch (vo.getVbusitype()) {
                    case "1": {
                        vo.setVbusitype("\u8de8\u533a\u501f\u7528");
                        break;
                    }
                    case "2": {
                        vo.setVbusitype("\u4e00\u8bc1\u591a\u7528");
                        break;
                    }
                }
            });
            Optional.ofNullable(vo.getBillState()).ifPresent(t -> vo.setBillStateName(BillStatusEnum.getDesc((Integer)t)));
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", vos);
        return beans;
    }

    @Override
    public CommonResponse<IPage<CertifySpecialReqBVO>> queryBPageByHParm(QueryParam param) {
        IPage page = this.bservice.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertifySpecialReqBVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

