package com.ejianc.business.dataexchange.api;

import com.ejianc.business.dataexchange.hyxtrix.ConstructorHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 入库单的rpc服务
 * 
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-dataexchange-web", url="${common.env.feign-client-url}", path="ejc-dataexchange-web", fallback = ConstructorHystrix.class)
public interface IConstructorApi {


    /*
    * 从人力系统同步数据
    * */
	@RequestMapping(value = "/api/constructor/query", method=RequestMethod.GET)
	 CommonResponse<String> queryConstructorInfo();



}
