package com.ejianc.business.dataexchange.api;

import com.ejianc.business.dataexchange.hyxtrix.CertificateHystrix;
import com.ejianc.business.dataexchange.hyxtrix.ConstructorHystrix;
import com.ejianc.business.dataexchange.vo.CertificateDeleteVO;
import com.ejianc.business.dataexchange.vo.CertificateVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 *
 * 人力系统人员证书接口
 * @author sunxy
 *
 */
@FeignClient(name= "ejc-dataexchange-web", url="${common.env.feign-client-url}", path="ejc-dataexchange-web", fallback = CertificateHystrix.class)
public interface ICertificateApi {


    /*
    * 从人力系统 获取人员证书信息
    * */
	@RequestMapping(value = "/api/certificate/query", method=RequestMethod.POST)
	 CommonResponse<List<CertificateVO>> query(@RequestBody QueryParam param);

	/*
	 * 从人力系统 获取人员证书信息,首次同步
	 * */
	@RequestMapping(value = "/api/certificate/queryFirst", method=RequestMethod.POST)
	CommonResponse<List<CertificateVO>> queryFirst(@RequestBody QueryParam param);
	/*
	 * 从人力系统 获取被删除的人员证书信息
	 * */
	@RequestMapping(value = "/api/certificateDelete/query", method=RequestMethod.POST)
	CommonResponse<List<CertificateDeleteVO>> queryDelete(@RequestBody QueryParam param);
}
