/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.design.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.design.bean.DrawingTypeEntity;
import com.ejianc.business.design.service.IDrawingTypeService;
import com.ejianc.business.design.vo.DrawingTypeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"drawingType"})
public class DrawingTypeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DRAWING_TYPE_CODE";
    @Autowired
    private IDrawingTypeService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DrawingTypeVO> saveOrUpdate(@RequestBody DrawingTypeVO saveOrUpdateVO) {
        Long parentId;
        DrawingTypeEntity entity = (DrawingTypeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DrawingTypeEntity.class));
        if (StringUtils.isEmpty((CharSequence)entity.getCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if ((parentId = saveOrUpdateVO.getParentId()) == null) {
            saveOrUpdateVO.setInnerCode(String.valueOf(saveOrUpdateVO.getId()));
        } else {
            DrawingTypeEntity parent = (DrawingTypeEntity)((Object)this.service.getById(parentId));
            saveOrUpdateVO.setInnerCode(parent.getInnerCode() + "|" + saveOrUpdateVO.getId());
        }
        this.service.saveOrUpdate((Object)entity, false);
        DrawingTypeVO vo = (DrawingTypeVO)BeanMapper.map((Object)((Object)entity), DrawingTypeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DrawingTypeVO> queryDetail(Long id) {
        DrawingTypeEntity entity = (DrawingTypeEntity)((Object)this.service.selectById(id));
        DrawingTypeVO vo = (DrawingTypeVO)BeanMapper.map((Object)((Object)entity), DrawingTypeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DrawingTypeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DrawingTypeVO drawingTypeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name", "checkPoint"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List subjectEntities = this.service.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)subjectEntities, Map.class);
        List treeData = ResultAsTree.createTreeData((List)resultMapList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)treeData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name", "checkPoint"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("DrawingType-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDrawingTypeData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refDrawingTypeData(String condition, String searchObject, String searchText) {
        JSONObject _con;
        Long orgId;
        if (StringUtils.isEmpty((CharSequence)condition) || !condition.contains("orgId")) {
            throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e: \u5fc5\u4f20\u53c2\u6570\u7ec4\u7ec7ID\u3010orgId\u3011");
        }
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "name"));
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (orgId = (_con = JSONObject.parseObject((String)condition)).getLong("orgId"))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        }
        List subjectEntities = this.service.queryList(param, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (DrawingTypeEntity entity : subjectEntities) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            JSONObject extdata = new JSONObject();
            extdata.put("checkPoint", (Object)entity.getCheckPoint());
            map.put("extdata", extdata);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/downloadTemplet"})
    @ResponseBody
    public void downloadTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"DrawingType-import.xlsx", (String)"\u56fe\u7eb8\u7c7b\u578b\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(@RequestParam(name="curOrgId", required=false) Long curOrgId, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<DrawingTypeVO> successList = new ArrayList<DrawingTypeVO>();
        ArrayList<DrawingTypeVO> errorList = new ArrayList<DrawingTypeVO>();
        if (result != null && result.size() > 0 && ((List)result.get(0)).size() != 3) {
            throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
        }
        HashMap<String, Integer> codeMap = new HashMap<String, Integer>();
        HashMap<String, DrawingTypeVO> parentMap = new HashMap<String, DrawingTypeVO>();
        for (int i = 0; i < result.size(); ++i) {
            int rowNum = i + 2;
            List row = (List)result.get(i);
            StringBuilder errMsg = new StringBuilder();
            StringBuilder errorFlag = new StringBuilder();
            if (row.get(1) == null) continue;
            DrawingTypeVO drawingTypeVO = new DrawingTypeVO();
            drawingTypeVO.setOrgId(curOrgId);
            String code = ((String)row.get(0)).trim();
            if (StringUtils.isNotBlank((CharSequence)code)) {
                drawingTypeVO.setCode(code);
                if (!codeMap.containsKey(code)) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(curOrgId != null, DrawingTypeEntity::getOrgId, (Object)curOrgId);
                    wrapper.eq(DrawingTypeEntity::getCode, (Object)code);
                    wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                    DrawingTypeEntity one = (DrawingTypeEntity)((Object)this.service.getOne((Wrapper)wrapper));
                    if (one != null) {
                        BeanUtils.copyProperties((Object)((Object)one), (Object)drawingTypeVO, (String[])new String[]{"code", "name", "checkPoint"});
                        errMsg.append("`\u7b2c" + rowNum + "\u884c\u56fe\u7eb8\u7f16\u7801\u5df2\u5b58\u5728\u3001\u53ef\u8986\u76d6\u66f4\u65b0`");
                        errorFlag.append("1");
                    }
                    codeMap.put(code, rowNum);
                } else {
                    errorFlag.append("2");
                    errMsg.append("`\u7b2c" + codeMap.get(code) + "\u3001" + rowNum + "\u884c\u56fe\u7eb8\u7f16\u7801\u91cd\u590d`");
                }
            } else {
                errorFlag.append("2");
                errMsg.append("`\u56fe\u7eb8\u7f16\u7801\u672a\u586b\u5199`");
            }
            String subjectName = ((String)row.get(1)).trim();
            if (StringUtils.isNotBlank((CharSequence)subjectName)) {
                drawingTypeVO.setName(subjectName);
            } else {
                errorFlag.append("2");
                errMsg.append("`\u56fe\u7eb8\u540d\u79f0\u672a\u586b\u5199`");
            }
            String fullName = ((String)row.get(2)).trim();
            if (StringUtils.isNotBlank((CharSequence)fullName)) {
                drawingTypeVO.setCheckPoint(fullName);
            }
            if (!errorFlag.toString().contains("2")) {
                DrawingTypeVO parentVO;
                if (drawingTypeVO.getId() == null) {
                    drawingTypeVO.setId(Long.valueOf(IdWorker.getId()));
                }
                String parentCode = code;
                if (code.contains(".")) {
                    parentCode = code.substring(0, code.lastIndexOf("."));
                }
                if ((parentVO = (DrawingTypeVO)parentMap.get(parentCode)) != null) {
                    drawingTypeVO.setParentId(parentVO.getId());
                    drawingTypeVO.setInnerCode(parentVO.getInnerCode() + "|" + drawingTypeVO.getId());
                } else {
                    drawingTypeVO.setInnerCode(drawingTypeVO.getId().toString());
                }
                parentMap.put(code, drawingTypeVO);
                successList.add(drawingTypeVO);
            }
            if (!StringUtils.isNotBlank((CharSequence)drawingTypeVO.getErrMsg())) continue;
            errorList.add(drawingTypeVO);
        }
        JSONObject json = new JSONObject();
        json.put("successList", (Object)BeanMapper.mapList(successList, DrawingTypeVO.class));
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/saveImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<DrawingTypeVO> drawingTypeVOS) {
        this.service.saveOrUpdateBatch(BeanMapper.mapList(drawingTypeVOS, DrawingTypeEntity.class));
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    public static void main(String[] args) {
        String a = "9.1";
        System.out.println(a.substring(0, a.lastIndexOf(".")));
    }
}

