package com.ejianc.business.doc.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 * @author CJ
 * @Description:
 * @date 2020/11/28 14:12
 */
public class ProjectDocVO extends BaseVO {

    private static final long serialVersionUID = -4089250516055268308L;
    /**
     * 文件Id
     */
    private Long fileId;
    /**
     * 文件名称
     */
    private String fileName;
    /**
     * 文件大小
     */
    private Long fileSize;
    /**
     * 文件类型
     */
    private String fileType;
    /**
     * 文件路径
     */
    private String filePath;

    /**
     * 文件预览路径
     */
    private String onlinePath;

    /**
     * 文件来源：0-附件归档，1-文件上传
     */
    private String docSource;
    /**
     * 项目Id
     */
    private Long projectId;

    /**
     * 组织Id
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 归档人Id
     */
    private Long superviseUserId;
    /**
     * 归档人名称
     */
    private String superviseUserName;
    /**
     * 归档时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date superviseTime;
    /**
     * 文档分类Id
     */
    private Long docCategoryId;

    /**
     * 文档分类名称
     */
    private String docCategoryName;

    /**
     * 归档附件对应业务单据详情页
     */
    private String detailPageUrl;

    /** 附件归档使用字段*/
    /**
     * 业务单据Id
     */
    private Long sourceId;
    /**
     * 业务单据对应单据类型
     */
    private String billType;
    /**
     * 业务单据中组织id对应属性名
     */
    private String orgIdField;
    /**
     * 业务单据中项目id对应属性名
     */
    private String projectIdField;

    /**
     * 业务单据编码对应属性
     */
    private String billCodeField;

    /**
     * 单据标识
     */
    private String billSymbol;

    public String getBillCodeField() {
        return billCodeField;
    }

    public void setBillCodeField(String billCodeField) {
        this.billCodeField = billCodeField;
    }

    public String getBillSymbol() {
        return billSymbol;
    }

    public void setBillSymbol(String billSymbol) {
        this.billSymbol = billSymbol;
    }

    public String getDocCategoryName() {
        return docCategoryName;
    }

    public void setDocCategoryName(String docCategoryName) {
        this.docCategoryName = docCategoryName;
    }

    public String getDetailPageUrl() {
        return detailPageUrl;
    }

    public void setDetailPageUrl(String detailPageUrl) {
        this.detailPageUrl = detailPageUrl;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getOrgIdField() {
        return orgIdField;
    }

    public void setOrgIdField(String orgIdField) {
        this.orgIdField = orgIdField;
    }

    public String getProjectIdField() {
        return projectIdField;
    }

    public void setProjectIdField(String projectIdField) {
        this.projectIdField = projectIdField;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOnlinePath() {
        return onlinePath;
    }

    public void setOnlinePath(String onlinePath) {
        this.onlinePath = onlinePath;
    }

    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getFileSize() {
        return fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getDocSource() {
        return docSource;
    }

    public void setDocSource(String docSource) {
        this.docSource = docSource;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getSuperviseUserId() {
        return superviseUserId;
    }

    public void setSuperviseUserId(Long superviseUserId) {
        this.superviseUserId = superviseUserId;
    }

    public String getSuperviseUserName() {
        return superviseUserName;
    }

    public void setSuperviseUserName(String superviseUserName) {
        this.superviseUserName = superviseUserName;
    }

    public Date getSuperviseTime() {
        return superviseTime;
    }

    public void setSuperviseTime(Date superviseTime) {
        this.superviseTime = superviseTime;
    }

    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }
}
