package com.ejianc.business.doc.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.KbmEntity;
import com.ejianc.business.doc.enums.KbmBillStateEnum;
import com.ejianc.business.doc.service.IKbmCategoryService;
import com.ejianc.business.doc.service.IKbmService;
import com.ejianc.business.doc.vo.KbmEsVO;
import com.ejianc.business.doc.vo.KbmVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

import static org.elasticsearch.common.xcontent.XContentFactory.jsonBuilder;

/**
 * 知识内容
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("kbm")
public class KbmController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IKbmService kbmService;

    @Autowired
    private IKbmCategoryService kbmCategoryService;

    @Autowired(required=false)
    private RestHighLevelClient client;

    @RequestMapping(path = "/initEs", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> initEs() {
        try {
            XContentBuilder mapping =  jsonBuilder().startObject().startObject("ejc_kbm_es").startObject("properties");
            mapping.startObject("tenantId").field("type", "text").endObject();
            mapping.startObject("categoryId").field("type", "text").endObject();
            mapping.startObject("categoryInnerCode").field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
            mapping.startObject("title").field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
            mapping.startObject("createUserName").field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
            mapping.startObject("categoryName").field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
            mapping.startObject("createTime").field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
            mapping.startObject("kbmDescribe").field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
            mapping.startObject("fileName").field("type", "text").field("analyzer","ik_max_word").field("search_analyzer","ik_smart").endObject();
            mapping.startObject("scanNum").field("type", "integer").endObject();
            mapping.startObject("collectNum").field("type", "integer").endObject();
            mapping.startObject("fileNum").field("type", "integer").endObject();
            mapping.endObject().endObject().endObject();
            PutMappingRequest mappingRequest = Requests.putMappingRequest("ejc_kbm_es").type("ejc_kbm_es").source(mapping);
            client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
            return CommonResponse.success();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.error("初始化失败");
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KbmVO> saveOrUpdate(@RequestBody KbmVO kbmVO) {
        KbmVO vo = kbmService.saveOrUpdate(kbmVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description commit 发布到知识中心
     */
    @RequestMapping(value = "/push", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KbmVO> push(Long id) {
        KbmVO vo = kbmService.push(id);
        return CommonResponse.success("发布单据成功！", vo);
    }

    /**
     * @Description commit 撤回
     */
    @RequestMapping(value = "/back", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KbmVO> back(Long id) {
        KbmVO vo = kbmService.back(id);
        return CommonResponse.success("撤回单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KbmVO> queryDetail(Long id) {
    	KbmEntity entity = kbmService.selectById(id);
    	KbmVO vo = BeanMapper.map(entity, KbmVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetailCenter  "知识中心"和"我的收藏"查询知识详情
     * @param id
     */
    @RequestMapping(value = "/scanDetailCenter", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KbmVO> scanDetailCenter(Long id, Integer fromList) {
        KbmVO vo = kbmService.scanDetailCenter(id, fromList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        kbmService.delete(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KbmVO>> queryList(@RequestBody Map<String, String> params) {
        QueryParam queryParam = new QueryParam();
        Integer pageSize = Integer.valueOf(params.get("pageSize"));
        Integer pageIndex = Integer.valueOf(params.get("pageIndex"));
        Long categoryId = Long.valueOf(params.get("categoryId"));
        String filterType = params.get("filterType");
        String searchText = null != params.get("searchText") ? params.get("searchText") : null;

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("title");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("categoryName");
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter(QueryParam.EQ, KbmBillStateEnum.已发布.getCode()));
        queryParam.setPageIndex(pageIndex);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);

        if ("1".equals(filterType)) {
            List<Long> categoryList = kbmCategoryService.adminFindChildrenId(categoryId).getData();
            queryParam.getParams().put("categoryId", new Parameter(QueryParam.IN, categoryList));
        } else {
            queryParam.getParams().put("categoryId", new Parameter(QueryParam.EQ, categoryId));
        }

        IPage<KbmEntity> page = kbmService.queryPage(queryParam,false);
        IPage<KbmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), KbmVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表（ES查询）
     * @param params
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListEs", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KbmEsVO> queryListEs(@RequestBody Map<String, String> params) {
        KbmEsVO kbmEsVO = kbmService.queryListEs(params);
        return CommonResponse.success("查询列表数据成功！", kbmEsVO);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListMine", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KbmVO>> queryListMine(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("title");
        fuzzyFields.add("createUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));

        IPage<KbmEntity> page = kbmService.queryPage(param,false);
        IPage<KbmVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), KbmVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryMineNum 查询我的暂存个数
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.Integer>
     */
    @RequestMapping(value = "/queryMineNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Integer> queryMineNum() {
        LambdaQueryWrapper<KbmEntity> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(KbmEntity::getCreateUserId, InvocationInfoProxy.getUserid());
        List<KbmEntity> list = kbmService.list(queryWrapper);
        return CommonResponse.success("查询列表数据成功！", CollectionUtils.isNotEmpty(list) ? list.size() : 0);
    }

    /**
     * @Description uploadFile 上传附件（管理端、同步es）
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/uploadFile", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> uploadFile(Long kbmId) {
        kbmService.uploadFile(kbmId);
        return CommonResponse.success("上传附件成功！");
    }

    /**
     * @Description deleteFile 删除附件（管理端、同步es）
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/deleteFile", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> deleteFile(Long kbmId) {
        kbmService.deleteFile(kbmId);
        return CommonResponse.success("删除附件成功！");
    }

    /**
     * @Description scanFile 浏览附件
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/scanFile", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> scanFile(Long kbmId, String fileId) {
        kbmService.scanFile(kbmId, fileId);
        return CommonResponse.success("浏览附件成功！");
    }

    /**
     * @Description batchDownloadFile 批量下载附件
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/batchDownloadFile", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> batchDownloadFile(Long kbmId, String fileId) {
        kbmService.batchDownloadFile(kbmId, fileId);
        return CommonResponse.success("批量下载附件成功！");
    }

    /**
     * @Description downloadFile 下载附件
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/downloadFile", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> downloadFile(Long kbmId, String fileId) {
        kbmService.downloadFile(kbmId, fileId);
        return CommonResponse.success("下载附件成功！");
    }
}
