/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.KbmEntity;
import com.ejianc.business.doc.enums.KbmBillStateEnum;
import com.ejianc.business.doc.service.IKbmCategoryService;
import com.ejianc.business.doc.service.IKbmService;
import com.ejianc.business.doc.vo.KbmBatchVO;
import com.ejianc.business.doc.vo.KbmEsVO;
import com.ejianc.business.doc.vo.KbmVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"kbm"})
public class KbmController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IKbmService kbmService;
    @Autowired
    private IKbmCategoryService kbmCategoryService;
    @Autowired(required=false)
    private RestHighLevelClient client;

    @RequestMapping(path={"/initEs"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> initEs() {
        try {
            XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("ejc_kbm_es").startObject("properties");
            mapping.startObject("tenantId").field("type", "text").endObject();
            mapping.startObject("categoryId").field("type", "text").endObject();
            mapping.startObject("categoryInnerCode").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("title").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("createUserName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("categoryName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("createTime").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("kbmDescribe").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("fileName").field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
            mapping.startObject("scanNum").field("type", "integer").endObject();
            mapping.startObject("collectNum").field("type", "integer").endObject();
            mapping.startObject("fileNum").field("type", "integer").endObject();
            mapping.endObject().endObject().endObject();
            PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{"ejc_kbm_es"}).type("ejc_kbm_es").source(mapping);
            this.client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
            return CommonResponse.success();
        }
        catch (IOException e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<KbmVO> saveOrUpdate(@RequestBody KbmVO kbmVO) {
        KbmVO vo = this.kbmService.saveOrUpdate(kbmVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/push"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KbmVO> push(Long id) {
        KbmVO vo = this.kbmService.push(id);
        return CommonResponse.success((String)"\u53d1\u5e03\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/back"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KbmVO> back(Long id) {
        KbmVO vo = this.kbmService.back(id);
        return CommonResponse.success((String)"\u64a4\u56de\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KbmVO> queryDetail(Long id) {
        KbmEntity entity = (KbmEntity)((Object)this.kbmService.selectById(id));
        KbmVO vo = (KbmVO)BeanMapper.map((Object)((Object)entity), KbmVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/scanDetailCenter"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<KbmVO> scanDetailCenter(Long id, Integer fromList) {
        KbmVO vo = this.kbmService.scanDetailCenter(id, fromList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.kbmService.delete(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<KbmVO>> queryList(@RequestBody Map<String, String> params) {
        QueryParam queryParam = new QueryParam();
        Integer pageSize = Integer.valueOf(params.get("pageSize"));
        Integer pageIndex = Integer.valueOf(params.get("pageIndex"));
        Long categoryId = Long.valueOf(params.get("categoryId"));
        String filterType = params.get("filterType");
        String searchText = null != params.get("searchText") ? params.get("searchText") : null;
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("title");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("categoryName");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("eq", (Object)KbmBillStateEnum.\u5df2\u53d1\u5e03.getCode()));
        queryParam.setPageIndex(pageIndex.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        if ("1".equals(filterType)) {
            List categoryList = (List)this.kbmCategoryService.adminFindChildrenId(categoryId).getData();
            queryParam.getParams().put("categoryId", new Parameter("in", (Object)categoryList));
        } else {
            queryParam.getParams().put("categoryId", new Parameter("eq", (Object)categoryId));
        }
        IPage page = this.kbmService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KbmVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListEs"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<KbmEsVO> queryListEs(@RequestBody Map<String, String> params) {
        KbmEsVO kbmEsVO = this.kbmService.queryListEs(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)kbmEsVO);
    }

    @RequestMapping(value={"/queryListMine"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<KbmVO>> queryListMine(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("title");
        fuzzyFields.add("createUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        IPage page = this.kbmService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), KbmVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMineNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Integer> queryMineNum() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(KbmEntity::getCreateUserId, (Object)InvocationInfoProxy.getUserid());
        List list = this.kbmService.list((Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)(CollectionUtils.isNotEmpty((Collection)list) ? list.size() : 0));
    }

    @RequestMapping(value={"/uploadFile"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> uploadFile(Long kbmId) {
        this.kbmService.uploadFile(kbmId);
        return CommonResponse.success((String)"\u4e0a\u4f20\u9644\u4ef6\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/deleteFile"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> deleteFile(Long kbmId) {
        this.kbmService.deleteFile(kbmId);
        return CommonResponse.success((String)"\u5220\u9664\u9644\u4ef6\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/scanFile"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> scanFile(Long kbmId, String fileId) {
        this.kbmService.scanFile(kbmId, fileId);
        return CommonResponse.success((String)"\u6d4f\u89c8\u9644\u4ef6\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/batchDownloadFile"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> batchDownloadFile(KbmBatchVO batchVO) {
        this.kbmService.batchDownloadFile(batchVO);
        return CommonResponse.success((String)"\u6279\u91cf\u4e0b\u8f7d\u9644\u4ef6\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/downloadFile"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> downloadFile(Long kbmId, String fileId) {
        this.kbmService.downloadFile(kbmId, fileId);
        return CommonResponse.success((String)"\u4e0b\u8f7d\u9644\u4ef6\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/batchMoveKbm"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> batchMoveKbm(KbmBatchVO batchVO) {
        this.kbmService.batchMoveKbm(batchVO);
        return CommonResponse.success((String)"\u6279\u91cf\u79fb\u52a8\u77e5\u8bc6\u6210\u529f\uff01");
    }
}

