package com.ejianc.business.doc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.doc.bean.KbmCollectDetailEntity;
import com.ejianc.business.doc.bean.KbmCollectEntity;
import com.ejianc.business.doc.mapper.KbmCollectMapper;
import com.ejianc.business.doc.service.IKbmCollectDetailService;
import com.ejianc.business.doc.service.IKbmCollectService;
import com.ejianc.business.doc.vo.KbmCollectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 知识库收藏夹
 *
 * @author generator
 *
 */
@Service("kbmCollectService")
public class KbmCollectServiceImpl extends BaseServiceImpl<KbmCollectMapper, KbmCollectEntity> implements IKbmCollectService{

    @Autowired
    private IKbmCollectDetailService kbmCollectDetailService;

    @Override
    public KbmCollectVO queryDetail(Long id) {
       KbmCollectEntity kbmCollectEntity =  selectById(id);
       return BeanMapper.map(kbmCollectEntity, KbmCollectVO.class);
    }

    @Override
    public void delete(Long id) {
        LambdaQueryWrapper<KbmCollectDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(KbmCollectDetailEntity::getCollectId, id);
        List<KbmCollectDetailEntity> detailEntityList = kbmCollectDetailService.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(detailEntityList)){
            for(KbmCollectDetailEntity detailEntity : detailEntityList){
                kbmCollectDetailService.cancelCollectKbm(detailEntity.getKbmId());
            }
        }
        super.removeById(id);
    }

    @Override
    public List<KbmCollectVO> queryListNormal() {
        LambdaQueryWrapper<KbmCollectEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(KbmCollectEntity::getCreateUserId, InvocationInfoProxy.getUserid());
        List<KbmCollectEntity> entityList = list(queryWrapper);
        List<KbmCollectVO> collectVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(entityList)){
            for(KbmCollectEntity kbmCollectEntity : entityList){
                KbmCollectVO kbmCollectVO = BeanMapper.map(kbmCollectEntity, KbmCollectVO.class);
                LambdaQueryWrapper<KbmCollectDetailEntity> queryWrapper1 = new LambdaQueryWrapper<>();
                queryWrapper1.eq(KbmCollectDetailEntity::getCollectId, kbmCollectEntity.getId());
                List<KbmCollectDetailEntity> detailEntities = kbmCollectDetailService.list(queryWrapper1);
                kbmCollectVO.setDetailNum(CollectionUtils.isNotEmpty(detailEntities) ? detailEntities.size() : 0);
                collectVOList.add(kbmCollectVO);
            }
        }
        return collectVOList;
    }
}
