/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.doc.bean.DocCategoryBillTypeRelationEntity;
import com.ejianc.business.doc.bean.DocCategoryEntity;
import com.ejianc.business.doc.mapper.DocCategoryBillTypeRelationMapper;
import com.ejianc.business.doc.service.IDocCategoryBillTypeRelationService;
import com.ejianc.business.doc.service.IDocCategoryService;
import com.ejianc.business.doc.vo.DocCategoryBillTypeRelationVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;

@Service(value="docCategoryBillTypeRelationService")
public class DocCategoryBillTypeRelationServiceImpl
extends BaseServiceImpl<DocCategoryBillTypeRelationMapper, DocCategoryBillTypeRelationEntity>
implements IDocCategoryBillTypeRelationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDocCategoryService docCategoryService;
    @Autowired
    private CacheManager cacheManager;
    private static final String CURRENTUSER_ROLE_KEY = "currentuser_role_key:";

    @Override
    public CommonResponse<String> saveDocCategoryBillType(List<DocCategoryBillTypeRelationVO> relationList) {
        ArrayList<Object> addList = new ArrayList<Object>();
        String roleName = "";
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"category_id", (Object)relationList.get(0).getCategoryId());
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.list((Wrapper)queryWrapper);
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        if (list != null && list.size() > 0) {
            for (Object relation : list) {
                map.put(((DocCategoryBillTypeRelationEntity)((Object)relation)).getBillTypeId(), relation);
                if (roleName.length() > 0) {
                    roleName = roleName + "\u3001" + ((DocCategoryBillTypeRelationEntity)((Object)relation)).getBillTypeName();
                    continue;
                }
                roleName = roleName + ((DocCategoryBillTypeRelationEntity)((Object)relation)).getBillTypeName();
            }
        }
        String message = "";
        for (DocCategoryBillTypeRelationVO docCategoryBillTypeRelationVO : relationList) {
            addList.add(BeanMapper.map((Object)((Object)docCategoryBillTypeRelationVO), DocCategoryBillTypeRelationEntity.class));
        }
        if (addList.size() > 0) {
            this.saveOrUpdateBatch(addList, addList.size(), false);
            for (DocCategoryBillTypeRelationEntity docCategoryBillTypeRelationEntity : addList) {
                map.put(docCategoryBillTypeRelationEntity.getBillTypeId(), (Object)docCategoryBillTypeRelationEntity);
                if (roleName.length() > 0) {
                    roleName = roleName + "\u3001" + docCategoryBillTypeRelationEntity.getBillTypeName();
                    continue;
                }
                roleName = roleName + docCategoryBillTypeRelationEntity.getBillTypeName();
            }
            DocCategoryEntity categoryEntity = (DocCategoryEntity)((Object)this.docCategoryService.getById(relationList.get(0).getCategoryId()));
            categoryEntity.setRoleName(roleName);
            this.docCategoryService.saveOrUpdate((Object)categoryEntity, false);
            if (addList.size() != relationList.size()) {
                return CommonResponse.success((String)("\u6dfb\u52a0\u6210\u529f,\u5176\u4e2d\u4ee5\u4e0b\u89d2\u8272\uff1a" + message + "\u5df2\u5b58\u5728"));
            }
        } else {
            return CommonResponse.success((String)"\u9009\u62e9\u7684\u89d2\u8272\u90fd\u5df2\u5728\u8be5\u5206\u7c7b\u4e0b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        return CommonResponse.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @Override
    public CommonResponse<String> deleteDocCategoryBillType(List<DocCategoryBillTypeRelationVO> relationList) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DocCategoryBillTypeRelationVO vo : relationList) {
            ids.add(vo.getId());
        }
        this.removeByIds(ids, false);
        String roleName = "";
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"category_id", (Object)relationList.get(0).getCategoryId());
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            for (DocCategoryBillTypeRelationEntity relation : list) {
                if (roleName.length() > 0) {
                    roleName = roleName + "\u3001" + relation.getBillTypeName();
                    continue;
                }
                roleName = roleName + relation.getBillTypeName();
            }
        }
        DocCategoryEntity categoryEntity = (DocCategoryEntity)((Object)this.docCategoryService.getById(relationList.get(0).getCategoryId()));
        categoryEntity.setRoleName(roleName);
        this.docCategoryService.saveOrUpdate((Object)categoryEntity, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public List<Long> getUserRoleCache(Long userId) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        final String key = CURRENTUSER_ROLE_KEY + userId + "-" + tenantId;
        Set roleIds = (Set)this.cacheManager.execute((CacheManager.JedisAction)new CacheManager.JedisAction<Set<String>>(){

            public Set<String> action(Jedis jedis) {
                return jedis.smembers(key);
            }
        });
        if (roleIds != null && !roleIds.isEmpty()) {
            for (String roleId : roleIds) {
                resultList.add(Long.parseLong(roleId));
            }
        }
        return resultList;
    }

    @Override
    public List<DocCategoryBillTypeRelationEntity> queryBillTypeIdList(String billTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bill_type_code", (Object)billTypeCode);
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }
}

