/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.LambdaUpdateChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dxcheck.dao.RecordDao;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.model.res.RecordRes;
import com.ejianc.business.dxcheck.model.vo.RecordAddEditVo;
import com.ejianc.business.dxcheck.model.vo.RecordDelVo;
import com.ejianc.business.dxcheck.model.vo.RecordScoreVo;
import com.ejianc.business.dxcheck.service.RecordServer;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.sql.Date;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecordServerImpl
implements RecordServer {
    private static final Logger log = LoggerFactory.getLogger(RecordServerImpl.class);
    private final RecordDao recordDao;
    private final RecordSubDao recordSubDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RecordRes add(RecordAddEditVo vo) {
        RecordEntity recordEntity = new RecordEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)recordEntity));
        recordEntity.setState(NumberUtils.INTEGER_ONE);
        this.recordDao.save((Object)recordEntity);
        List saveRecordSubEntityList = Lists.newArrayList();
        List<RecordAddEditVo.AddRecordSubEntity> recordSubEntities = vo.getRecordSubEntities();
        recordSubEntities.forEach(e -> {
            BeanUtils.copyProperties((Object)((Object)recordEntity), (Object)e);
            RecordSubEntity recordSubEntity = new RecordSubEntity();
            BeanUtils.copyProperties((Object)e, (Object)((Object)recordSubEntity));
            recordSubEntity.setId(null);
            recordSubEntity.setRecordId(recordEntity.getId());
            recordSubEntity.setState(StrUtil.isNotEmpty((CharSequence)recordSubEntity.getSelfScore()) ? 1 : 0);
            saveRecordSubEntityList.add(recordSubEntity);
        });
        this.recordSubDao.saveBatch(saveRecordSubEntityList);
        return this.buildRes(recordEntity, saveRecordSubEntityList);
    }

    @Override
    public void del(RecordDelVo vo) {
        List<Long> ids = vo.getIds();
        List<Long> subIdList = vo.getSubIdList();
        if (!ids.isEmpty()) {
            try {
                this.recordDao.removeByIds(ids);
                ((LambdaUpdateChainWrapper)this.recordSubDao.lambdaUpdate().in(RecordSubEntity::getRecordId, ids)).remove();
                return;
            }
            catch (Exception e) {
                throw new BusinessException("\u5217\u8868\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage());
            }
        }
        if (!subIdList.isEmpty()) {
            try {
                this.recordSubDao.removeByIds(subIdList);
                return;
            }
            catch (Exception e) {
                throw new BusinessException("\u660e\u7ec6\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage());
            }
        }
        throw new BusinessException("\u5217\u8868\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5220\u9664\u7684\u6761\u76ee");
    }

    @Override
    public RecordRes detail(Long id) {
        RecordEntity recordEntity = (RecordEntity)((Object)((LambdaQueryChainWrapper)this.recordDao.lambdaQuery().eq(BaseEntity::getId, (Object)id)).one());
        if (Objects.isNull((Object)recordEntity)) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25,\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List recordSubEntityList = ((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getRecordId, (Object)id)).list();
        return this.buildRes(recordEntity, recordSubEntityList);
    }

    @Override
    public IPage<RecordEntity> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList(new String[0]));
        param.getOrderMap().put("createTime", "desc");
        return this.recordDao.queryPage(param, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RecordRes edit(RecordAddEditVo vo) {
        RecordEntity recordEntity = (RecordEntity)((Object)this.recordDao.getById(vo.getId()));
        BeanUtils.copyProperties((Object)vo, (Object)((Object)recordEntity));
        recordEntity.setModificationTime(new Date(System.currentTimeMillis()));
        this.recordDao.updateById((Object)recordEntity);
        List<RecordAddEditVo.AddRecordSubEntity> recordSubEntities = vo.getRecordSubEntities();
        if (recordSubEntities.isEmpty()) {
            throw new BusinessException("\u81f3\u5c11\u9700\u8981\u4e00\u6761\u6307\u6807");
        }
        List saveRecordSubEntityList = Lists.newArrayList();
        List editRecordSubEntityList = Lists.newArrayList();
        recordSubEntities.forEach(e -> {
            Long recordSubId = e.getId();
            if (Objects.isNull(recordSubId)) {
                BeanUtils.copyProperties((Object)((Object)recordEntity), (Object)e);
                e.setRecordId(recordEntity.getId());
                RecordSubEntity recordSubEntity = new RecordSubEntity();
                BeanUtils.copyProperties((Object)e, (Object)((Object)recordSubEntity));
                recordSubEntity.setModifierJobNum(vo.getModifierJobNum());
                recordSubEntity.setState(StrUtil.isNotEmpty((CharSequence)recordSubEntity.getSelfScore()) ? 1 : 0);
                saveRecordSubEntityList.add(recordSubEntity);
            } else {
                RecordSubEntity recordSubEntity = (RecordSubEntity)((Object)((Object)this.recordSubDao.getById(recordSubId)));
                recordSubEntity.setAssessmentUnitCode(vo.getAssessmentUnitCode());
                recordSubEntity.setAssessmentUnitName(vo.getAssessmentUnitName());
                recordSubEntity.setAssessmentEventType(vo.getAssessmentEventType());
                recordSubEntity.setAssessmentContent(vo.getAssessmentContent());
                recordSubEntity.setAssessorJobNum(vo.getAssessorJobNum());
                recordSubEntity.setAssessorName(vo.getAssessorName());
                recordSubEntity.setModifierJobNum(vo.getModifierJobNum());
                recordSubEntity.setScoreOfYear(e.getScoreOfYear());
                recordSubEntity.setScoreOfSeason(e.getScoreOfSeason());
                recordSubEntity.setAssessmentSubject(e.getAssessmentSubject());
                recordSubEntity.setState(StrUtil.isNotEmpty((CharSequence)e.getSelfScore()) ? 1 : 0);
                recordSubEntity.setSelfScore(e.getSelfScore());
                recordSubEntity.setSelfScoreReason(e.getSelfScoreReason());
                recordSubEntity.setSupportMaterialSelf(e.getSupportMaterialSelf());
                editRecordSubEntityList.add(recordSubEntity);
            }
        });
        this.recordSubDao.saveBatch(saveRecordSubEntityList);
        this.recordSubDao.updateBatchById(editRecordSubEntityList);
        List recordSubEntityList = Lists.newArrayList();
        recordSubEntityList.addAll(saveRecordSubEntityList);
        recordSubEntityList.addAll(editRecordSubEntityList);
        List<Long> removeRecordSubIdList = vo.getRemoveRecordSubIdList();
        if (!removeRecordSubIdList.isEmpty()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordSubDao.lambdaUpdate().in(BaseEntity::getId, removeRecordSubIdList)).set(RecordSubEntity::getModifierJobNum, (Object)vo.getModifierJobNum())).update();
            this.recordSubDao.removeByIds(removeRecordSubIdList);
        }
        RecordRes recordRes = new RecordRes();
        BeanUtils.copyProperties((Object)((Object)recordEntity), (Object)recordRes);
        List<RecordRes.AddRecordSubEntity> subEntityList = recordSubEntityList.stream().map(recordSubEntity -> {
            RecordRes.AddRecordSubEntity resRecordSubEntity = new RecordRes.AddRecordSubEntity();
            BeanUtils.copyProperties((Object)recordSubEntity, (Object)resRecordSubEntity);
            return resRecordSubEntity;
        }).collect(Collectors.toList());
        recordRes.setRecordSubEntitiyList(subEntityList);
        recordRes.setRemoveRecordSubIdList(removeRecordSubIdList);
        return recordRes;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void score(RecordScoreVo vo) {
        Long recordId = vo.getRecordId();
        Long recordSubId = vo.getRecordSubId();
        String suggestScore = vo.getSuggestScore();
        try {
            String finalScore;
            String preliminaryScore;
            if (StrUtil.isNotEmpty((CharSequence)suggestScore)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordSubDao.lambdaUpdate().eq(BaseEntity::getId, (Object)recordSubId)).set(RecordSubEntity::getState, (Object)2)).set(RecordSubEntity::getSuggestScore, (Object)suggestScore)).set(RecordSubEntity::getSuggestReason, (Object)vo.getSuggestReason())).set(RecordSubEntity::getSupportMaterialMajor, (Object)vo.getSupportMaterialMajor())).update();
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordDao.lambdaUpdate().eq(BaseEntity::getId, (Object)recordId)).set(RecordEntity::getState, (Object)2)).update();
            }
            if (StrUtil.isNotEmpty((CharSequence)(preliminaryScore = vo.getPreliminaryScore()))) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordSubDao.lambdaUpdate().eq(BaseEntity::getId, (Object)recordSubId)).set(RecordSubEntity::getState, (Object)3)).set(RecordSubEntity::getPreliminaryScore, (Object)preliminaryScore)).set(RecordSubEntity::getPreliminaryReason, (Object)vo.getPreliminaryReason())).set(RecordSubEntity::getSupportMaterialPrelim, (Object)vo.getSupportMaterialPrelim())).update();
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordDao.lambdaUpdate().eq(BaseEntity::getId, (Object)recordId)).set(RecordEntity::getState, (Object)3)).update();
            }
            if (StrUtil.isNotEmpty((CharSequence)(finalScore = vo.getFinalScore()))) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordSubDao.lambdaUpdate().eq(BaseEntity::getId, (Object)recordSubId)).set(RecordSubEntity::getState, (Object)4)).set(RecordSubEntity::getFinalScore, (Object)finalScore)).set(RecordSubEntity::getFinalReason, (Object)vo.getFinalReason())).update();
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordDao.lambdaUpdate().eq(BaseEntity::getId, (Object)recordId)).set(RecordEntity::getState, (Object)4)).update();
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u8bc4\u5206\u5931\u8d25\uff0c\u539f\u56e0\uff1a:" + e.getMessage());
        }
        finally {
            Integer minState = ((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getRecordId, (Object)recordId)).list().stream().map(RecordSubEntity::getState).min(Integer::compareTo).orElse(0);
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordDao.lambdaUpdate().eq(BaseEntity::getId, (Object)recordId)).set(RecordEntity::getState, (Object)minState)).update();
        }
    }

    private RecordRes buildRes(RecordEntity recordEntity, List<RecordSubEntity> saveRecordSubEntityList) {
        RecordRes recordRes = new RecordRes();
        BeanUtils.copyProperties((Object)((Object)recordEntity), (Object)recordRes);
        List<RecordRes.AddRecordSubEntity> subEntityList = saveRecordSubEntityList.stream().map(recordSubEntity -> {
            RecordRes.AddRecordSubEntity resRecordSubEntity = new RecordRes.AddRecordSubEntity();
            BeanUtils.copyProperties((Object)recordSubEntity, (Object)resRecordSubEntity);
            return resRecordSubEntity;
        }).collect(Collectors.toList());
        recordRes.setRecordSubEntitiyList(subEntityList);
        return recordRes;
    }

    public RecordServerImpl(RecordDao recordDao, RecordSubDao recordSubDao) {
        this.recordDao = recordDao;
        this.recordSubDao = recordSubDao;
    }
}

