package com.ejianc.business.dxcheck.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;


/**
 * @Author: LCL
 * @Date: 2024/5/28 上午9:53
 * @Description: 考核记录
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_dxcheck_record")
@Builder
public class RecordEntity extends BaseEntity {
    /**
     * 项目ID
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 项目编码
     */
    @TableField(value = "project_code")
    private String projectCode;

    /**
     * 项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 项目组织ID
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 项目组织编码
     */
    @TableField(value = "org_code")
    private String orgCode;

    /**
     * 项目组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 父级组织ID
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 父级组织编码
     */
    @TableField(value = "parent_org_code")
    private String parentOrgCode;

    /**
     * 父级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;

    /**
     * 单据编码
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 考核单位/部门Code
     */
    @TableField(value = "assessment_unit_code")
    private String assessmentUnitCode;

    /**
     * 考核单位/部门名称
     */
    @TableField(value = "assessment_unit_name")
    private String assessmentUnitName;

    /**
     * 考评事件类型（字典项：单位发起评分 考评组发起评分 专业组直接评分 考评组直接评分）
     */
    @TableField(value = "assessment_event_type")
    private String assessmentEventType;

    /**
     * 考核内容
     */
    @TableField(value = "assessment_content")
    private String assessmentContent;

    /**
     * 考核人员工号
     */
    @TableField(value = "assessor_job_num")
    private String assessorJobNum;

    /**
     * 考核人员
     */
    @TableField(value = "assessor_name")
    private String assessorName;

    /**
     * 修改人工号
     */
    @TableField(value = "modifier_job_num")
    private String modifierJobNum;

    /**
     * 修改人姓名
     */
    @TableField(value = "modifier_name")
    private String modifierName;

    /**
     * 修改人修改时间
     */
    @TableField(value = "modification_time")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date modificationTime;

    /**
     * 状态：（0新增完成；1待专业组评分；2待考评组初审；3待考评组长终评；4考评结束）
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 批量发起考评编码（专业化组或者考评组批量发起时使用）
     */
    @TableField(value = "batch_assessment_code")
    private Integer batchAssessmentCode;
}
