package com.ejianc.business.dxcheck.model.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/29 上午9:51
 * @Description: 考核记录
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RecordAddEditVo {
    /**
     * RecordId
     */
    private Long id;
    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 项目编码
     */
    private String projectCode;

    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 父级组织ID
     */
    private Long parentOrgId;

    /**
     * 父级组织编码
     */
    private String parentOrgCode;

    /**
     * 父级组织名称
     */
    private String parentOrgName;

    /**
     * 单据编码
     */
    private String billCode;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 考核单位/部门Code
     */
    private String assessmentUnitCode;

    /**
     * 考核单位/部门名称
     */
    private String assessmentUnitName;

    /**
     * 考评事件类型（字典项：单位发起评分 考评组发起评分 专业组直接评分 考评组直接评分）
     */
    private String assessmentEventType;

    /**
     * 考核内容
     */
    private String assessmentContent;

    /**
     * 考核人员工号
     */
    private String assessorJobNum;

    /**
     * 考核人员
     */
    private String assessorName;

    /**
     * 修改人工号
     */
    private String modifierJobNum;

    /**
     * 修改人姓名
     */
    private String modifierName;

    /**
     * 状态：（0新增完成；1待专业组评分；2待考评组初审；3待考评组长终评；4考评结束）
     */
    private Integer state;

    /**
     * 批量发起考评编码（专业化组或者考评组批量发起时使用）
     */
    private Integer batchAssessmentCode;

    /**
     * 新增/修改 考核记录子表信息
     */
    @NotNull(message = "指标不能为空")
    private List<AddEditRecordSubInfo> recordSubEntities;

    private List<Long> removeRecordSubIdList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class AddEditRecordSubInfo {
        /**
         * RecordSubId
         */
        private Long id;
        /**
         * 考核记录id
         */
        private Long recordId;

        /**
         * 考核单位/部门code
         */
        private String assessmentUnitCode;

        /**
         * 考核单位/部门名称
         */
        private String assessmentUnitName;

        /**
         * 考评事件类型（字典项：单位发起评分 考评组发起评分 专业组直接评分 考评组直接评分）
         */
        private String assessmentEventType;

        /**
         * 考核内容
         */
        private String assessmentContent;

        /**
         * 考核人员工号
         */
        private String assessorJobNum;

        /**
         * 考核人员
         */
        private String assessorName;

        /**
         * 修改人工号
         */
        private String modifierJobNum;

        /**
         * 指标id
         */
        private Long normId;

        /**
         * 指标序号
         */
        private String normNum;

        /**
         * 一级分类
         */
        private String firstClassify;

        /**
         * 二级分类
         */
        private String secondClassify;

        /**
         * 指标内容
         */
        private String normContent;

        /**
         * 加分上限
         */
        private String plusLimit;

        /**
         * 扣分上限制
         */
        private String reduceLimit;

        /**
         * 本部部门（使用选√，不适用—，也可选择单位）
         */
        private String headquarterDepartment;

        /**
         * 分子公司（使用选√，不适用—，也可选择单位）
         */
        private String subsidiaryCompany;

        /**
         * 直管项目（使用选√，不适用—，也可选择单位）
         */
        private String straightProject;

        /**
         * 指标版本
         */
        private String normVersion;

        /**
         * 指标状态
         */
        private String normState;

        /**
         * 分值所属年份（自动带入，可修改）
         */
        private String scoreOfYear;

        /**
         * 分值所属季度（自动带入，可修改）
         */
        private String scoreOfSeason;

        /**
         * 考评主题
         */
        private String assessmentSubject;

        /**
         * 自评分（单位自评）
         */
        private String selfScore;

        /**
         * 自评理由（单位自评）
         */
        private String selfScoreReason;

        /**
         * 支持材料（单位自评）
         */
        private String supportMaterialSelf;
    }
}
