/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dxcheck.entity.TeamEntity;
import com.ejianc.business.dxcheck.model.vo.TeamVO;
import com.ejianc.business.dxcheck.service.TeamService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"team"})
public class TeamController
implements Serializable {
    @Autowired
    private TeamService service;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TeamVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("assessmentUnitName");
        fuzzyFields.add("assessorName");
        fuzzyFields.add("leaderProjectManagementName");
        fuzzyFields.add("leaderUnitResponseName");
        fuzzyFields.add("leaderInfoDepartmentName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TeamVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TeamVO> queryDetail(Long id) {
        TeamEntity entity = (TeamEntity)((Object)this.service.selectById(id));
        TeamVO vo = (TeamVO)((Object)BeanMapper.map((Object)((Object)entity), TeamVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TeamVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TeamVO teamVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TeamVO> saveOrUpdate(@RequestBody TeamVO saveOrUpdateVO) {
        System.out.println("\u6253\u5370\u65f6\u95f4" + saveOrUpdateVO.getModifyTime());
        TeamEntity entity = (TeamEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), TeamEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        TeamVO vo = (TeamVO)((Object)BeanMapper.map((Object)((Object)entity), TeamVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u8005\u4fee\u6539\u5355\u636e\u6210\u529f", (Object)((Object)vo));
    }
}

