package com.ejianc.business.dxcheck.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;


/**
 * @Author: LCL
 * @Date: 2024/5/28 上午9:53
 * @Description: 考核指标
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_dxcheck_norm")
@Builder
public class NormEntity extends BaseEntity {
    /**
     * 序号
     */
    @TableField(value = "serial_num")
    private String serialNum;

    /**
     * 一级分类
     */
    @TableField(value = "first_classify")
    private String firstClassify;

    /**
     * 二级分类
     */
    @TableField(value = "second_classify")
    private String secondClassify;

    /**
     * 指标内容
     */
    @TableField(value = "norm_content")
    private String normContent;

    /**
     * 加分上限
     */
    @TableField(value = "plus_limit")
    private String plusLimit;

    /**
     * 扣分上限
     */
    @TableField(value = "reduce_limit")
    private String reduceLimit;

    /**
     * 本部部门（使用选√，不适用—，也可选择单位）
     */
    @TableField(value = "headquarter_department")
    private String headquarterDepartment;

    /**
     * 分子公司（使用选√，不适用—，也可选择单位）
     */
    @TableField(value = "subsidiary_company")
    private String subsidiaryCompany;

    /**
     * 直管项目（使用选√，不适用—，也可选择单位）
     */
    @TableField(value = "straight_project")
    private String straightProject;

    /**
     * 版本
     */
    @TableField(value = "norm_version")
    private String normVersion;

    /**
     * 状态
     */
    @TableField(value = "state")
    private Boolean state;

    /**
     * 修改人工号
     */
    @TableField(value = "modifier_job_num")
    private String modifierJobNum;

    /**
     * 修改人
     */
    @TableField(value = "modifier_name")
    private String modifierName;

    /**
     * 修改人修改时间
     */
    @TableField(value = "modify_time")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date modifyTime;

    /**
     * 原指标
     */
    @TableField(value = "old_norm")
    private Long oldNorm;
}
