package com.ejianc.business.dxcheck.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.service.RankServer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: LCL
 * @Date: 2024/6/4 下午3:36
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class RankServerImpl implements RankServer {
    private final RecordSubDao recordSubDao;

    @Override
    public void nucleus() {
        //年度总分
        int totalAnnualScore = 100;
        /**
         * 当前季度
         */
        //当前季度的起始时间 终止时间
        DateTime quarterStartTime = DateUtil.beginOfQuarter(new Date());
        DateTime quarterEndTime = DateUtil.endOfQuarter(new Date());
        //当前季度的数据
        List<RecordSubEntity> nowQuarterList = recordSubDao.lambdaQuery()
                .eq(BaseEntity::getDr, 0)
                .isNotNull(RecordSubEntity::getFinalScore)
                .between(BaseEntity::getCreateTime, quarterStartTime, quarterEndTime)
                .list();

        /**
         * 当年
         */
        //当年的起始时间 终止时间
        DateTime yearStartTime = DateUtil.beginOfYear(new Date());
        DateTime yearEndTime = DateUtil.endOfYear(new Date());
        //当年的数据
        List<RecordSubEntity> nowYearList = recordSubDao.lambdaQuery()
                .eq(BaseEntity::getDr, 0)
                .isNotNull(RecordSubEntity::getFinalScore)
                .between(BaseEntity::getCreateTime, yearStartTime, yearEndTime)
                .list();

        /**
         * 本部 org_type=4
         */
        List<RecordSubEntity> bbYearList = nowYearList.stream().filter(e -> e.getOrgType() == 4).collect(Collectors.toList());
        List<RecordSubEntity> bbQuarterList = nowQuarterList.stream().filter(e -> e.getOrgType() == 4).collect(Collectors.toList());
        disposeScores(bbQuarterList, bbYearList, totalAnnualScore);
        /**
         * 分子公司 org_type=2
         */
        List<RecordSubEntity> fzgsYearList = nowYearList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());
        List<RecordSubEntity> fzgsQuarterList = nowQuarterList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());
        disposeScores(fzgsQuarterList, fzgsYearList, totalAnnualScore);
        /**
         * 项目 org_type=3、5
         */
        List<RecordSubEntity> xmYearList = nowYearList.stream().filter(e -> e.getOrgType() == 3 || e.getOrgType() == 5).collect(Collectors.toList());
        List<RecordSubEntity> xmQuarterList = nowQuarterList.stream().filter(e -> e.getOrgType() == 3 || e.getOrgType() == 5).collect(Collectors.toList());
        disposeScores(xmQuarterList, xmYearList, totalAnnualScore);
    }

    /**
     * 分数处理
     *
     * @param quarterList      当前季度  只是用来显示，不参与分数计算
     * @param yearList         当年  纬度最大，以这个为基础计算总分 用来参与分数计算  加上年度总分初始赋分
     * @param totalAnnualScore 年度总分 = 初始分 + 当年分数(可能为负数)
     */
    private void disposeScores(List<RecordSubEntity> quarterList, List<RecordSubEntity> yearList, Integer totalAnnualScore) {
        Map<String, Map<String, List<RecordSubEntity>>> unitDepartmentMap = yearList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitCode,
                Collectors.groupingBy(RecordSubEntity::getAssessmentDepartmentCode)));
        for (Map.Entry<String, Map<String, List<RecordSubEntity>>> stringMapEntry : unitDepartmentMap.entrySet()) {
            String unitCode = stringMapEntry.getKey();
            Map<String, List<RecordSubEntity>> value = stringMapEntry.getValue();
            for (Map.Entry<String, List<RecordSubEntity>> stringListEntry : value.entrySet()) {
                String departmentCode = stringListEntry.getKey();
                List<RecordSubEntity> recordSubList = stringListEntry.getValue();
                //该 单位——部门 年度分
                int yearSum = recordSubList.stream().mapToInt(RecordSubEntity::getFinalScore).sum();
            }
        }
    }
}
