package com.ejianc.business.dxcheck.controller;

import com.ejianc.business.dxcheck.model.res.AssessmentRankRes;
import com.ejianc.business.dxcheck.model.res.RecordStatisticsRes;
import com.ejianc.business.dxcheck.service.StatisticsServer;
import com.ejianc.framework.core.response.CommonResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;


/**
 * @Author: LCL
 * @Date: 2024/6/4 下午3:35
 * @Description: 统计
 */
@Controller
@RequestMapping("statistics")
@RequiredArgsConstructor
public class StatisticsController {
    private final StatisticsServer server;

    /**
     * 考核排名统计
     *
     * @return AssessmentRankRes
     */
    @RequestMapping(value = "assessmentRank", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AssessmentRankRes> assessmentRank() {
        return CommonResponse.success("考核排名统计", server.assessmentRank());
    }

    /**
     * 考核记录统计
     *
     * @param departmentCode 部门代码
     * @return 汇总数据
     */
    @RequestMapping(value = "record", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RecordStatisticsRes> record(@RequestParam("departmentCode") String departmentCode) {
        return CommonResponse.success("考核记录统计", server.record(departmentCode));
    }
}
