package com.ejianc.business.dxcheck.controller;/*author Wyx*/

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dxcheck.entity.UserEntity;
import com.ejianc.business.dxcheck.service.UserService;
import com.ejianc.business.dxcheck.model.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wyx
 *单位用户配置
 */
@Controller
@RequestMapping("user")
public class UserController implements Serializable {
    @Autowired
    private UserService service;
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UserVO>> queryList(@RequestBody QueryParam param) {
        /**模糊搜索配置字段示例*/
    List<String> fuzzyFields = param.getFuzzyFields();
    fuzzyFields.add("assessmentUnitName");
    fuzzyFields.add("assessorName");
    fuzzyFields.add("leaderProjectManagementName");
    fuzzyFields.add("leaderUnitResponseName");
    fuzzyFields.add("leaderInfoDepartmentName");
    /** 租户隔离 */
    param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
    IPage<UserEntity> page = service.queryPage(param, false);
    IPage<UserVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
    pageData.setRecords(BeanMapper.mapList(page.getRecords(), UserVO.class));
    return CommonResponse.success("查询列表数据成功",pageData);
    }

    /**
     * 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UserVO> queryDetail(Long id) {
        UserEntity entity = service.selectById(id);
        UserVO vo = BeanMapper.map(entity, UserVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UserVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (UserVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(UserVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UserVO> saveOrUpdate(@RequestBody UserVO saveOrUpdateVO){
        System.out.println("打印时间"+saveOrUpdateVO.getModifyTime());
        UserEntity entity = BeanMapper.map(saveOrUpdateVO, UserEntity.class);
        service.saveOrUpdate(entity,false);
        UserVO vo = BeanMapper.map(entity, UserVO.class);
        return CommonResponse.success("保存或者修改单据成功",vo);
    }
}
