package com.ejianc.business.dxcheck.dao.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dxcheck.dao.RecordDao;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.model.NewApproveInfo;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.CommonBusinessParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Service("record")
@Slf4j
public class RecordBpmServiceImpl implements ICommonBusinessService {
    @Qualifier("com.ejianc.foundation.orgcenter.api.IUserApi")
    @Autowired
    private IUserApi iUserApi;

    @Autowired
    private RecordDao recordDao;

    @Autowired
    private RecordSubDao recordSubDao;

    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        recordDao.lambdaUpdate().eq(BaseEntity::getId, billId).set(RecordEntity::getState, NumberUtils.INTEGER_ONE).update();
        recordSubDao.lambdaUpdate().eq(RecordSubEntity::getRecordId, billId).set(RecordSubEntity::getState, state).update();
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> approveUserList(CommonBusinessParam businessParam) {
        log.info("record_approveUserList回调：{}", JSONUtil.toJsonStr(businessParam));
        //元数据id(recordSub.id)
        Long metadataId = businessParam.getMetadataId();
        JSONArray newApproveInfo = businessParam.getNewApproveInfo();
        List<NewApproveInfo> newApproveInfoList = newApproveInfo.toJavaList(NewApproveInfo.class);
        List<String> approveUserIdList = Lists.newArrayList();
        List<UserVO> approveUserInfoList = Lists.newArrayList();
        String approveUserInfo = "";
        if (!newApproveInfoList.isEmpty()) {
            newApproveInfoList.forEach(e -> {
                approveUserIdList.addAll(e.getApproveUserList());
            });
            CommonResponse<List<UserVO>> userList = iUserApi.queryListByIds(approveUserIdList.toArray(new String[0]));
            List<UserVO> data = userList.getData();
            if (userList.isSuccess() && data != null && !data.isEmpty()) {
                approveUserInfoList.addAll(data);
            }
            //获取节点审批所有用户信息
            approveUserInfo = JSONUtil.toJsonStr(approveUserInfoList);
        }
        RecordEntity one = recordDao.lambdaQuery().eq(BaseEntity::getId, metadataId).one();
        if (Objects.nonNull(one)) {
            recordSubDao.lambdaUpdate().eq(RecordSubEntity::getRecordId, metadataId).set(RecordSubEntity::getApproveUserInfo, approveUserInfo).update();
            recordDao.lambdaUpdate().eq(BaseEntity::getId, metadataId).set(RecordEntity::getApproveUserInfo, approveUserInfo).update();
        }
        return CommonResponse.success();
    }

}
