package com.ejianc.business.dxcheck.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @Author: LCL
 * @Date: 2024/5/28 上午9:53
 * @Description: 考核记录指标信息
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_dxcheck_record_sub")
@Builder
public class RecordSubEntity extends BaseEntity {
    /**
     * 审批节点用户信息
     */
    @TableField(value = "approve_user_info")
    private String approveUserInfo;
    /**
     * 考核记录id
     */
    @TableField(value = "record_id")
    private Long recordId;

    /**
     * 2—分子公司 4—本部  3、5—项目
     */
    @TableField(value = "org_type")
    private Integer orgType;

    /**
     * 考核单位id
     */
    @TableField(value = "assessment_unit_id")
    private String assessmentUnitId;

    /**
     * 考核单位code
     */
    @TableField(value = "assessment_unit_code")
    private String assessmentUnitCode;

    /**
     * 考核单位名称
     */
    @TableField(value = "assessment_unit_name")
    private String assessmentUnitName;

    /**
     * 考核部门id
     */
    @TableField(value = "assessment_department_id")
    private String assessmentDepartmentId;

    /**
     * 考核部门code
     */
    @TableField(value = "assessment_department_code")
    private String assessmentDepartmentCode;

    /**
     * 考核部门名称
     */
    @TableField(value = "assessment_department_name")
    private String assessmentDepartmentName;

    /**
     * 考评事件类型（字典项：单位发起评分 考评组发起评分 专业组直接评分 考评组直接评分）
     */
    @TableField(value = "assessment_event_type")
    private String assessmentEventType;

    /**
     * 考核内容
     */
    @TableField(value = "assessment_content")
    private String assessmentContent;

    /**
     * 考核人员工号
     */
    @TableField(value = "assessor_job_num")
    private String assessorJobNum;

    /**
     * 考核人员
     */
    @TableField(value = "assessor_name")
    private String assessorName;

    /**
     * 修改人工号
     */
    @TableField(value = "modifier_job_num")
    private String modifierJobNum;

    /**
     * 指标id
     */
    @TableField(value = "norm_id")
    private Long normId;

    /**
     * 指标序号
     */
    @TableField(value = "norm_num")
    private String normNum;

    /**
     * 一级分类
     */
    @TableField(value = "first_classify")
    private String firstClassify;

    /**
     * 二级分类
     */
    @TableField(value = "second_classify")
    private String secondClassify;

    /**
     * 指标内容
     */
    @TableField(value = "norm_content")
    private String normContent;

    /**
     * 加分上限
     */
    @TableField(value = "plus_limit")
    private String plusLimit;

    /**
     * 扣分上限制
     */
    @TableField(value = "reduce_limit")
    private String reduceLimit;

    /**
     * 本部部门（使用选√，不适用—，也可选择单位）
     */
    @TableField(value = "headquarter_department")
    private String headquarterDepartment;

    /**
     * 分子公司（使用选√，不适用—，也可选择单位）
     */
    @TableField(value = "subsidiary_company")
    private String subsidiaryCompany;

    /**
     * 直管项目（使用选√，不适用—，也可选择单位）
     */
    @TableField(value = "straight_project")
    private String straightProject;

    /**
     * 指标版本
     */
    @TableField(value = "norm_version")
    private String normVersion;

    /**
     * 指标状态
     */
    @TableField(value = "norm_state")
    private String normState;

    /**
     * 分值所属年份（自动带入，可修改）
     */
    @TableField(value = "scoreOfYear")
    private String scoreOfYear;

    /**
     * 分值所属季度（自动带入，可修改）
     */
    @TableField(value = "scoreOfSeason")
    private String scoreOfSeason;

    /**
     * 考评主题
     */
    @TableField(value = "assessment_subject")
    private String assessmentSubject;

    /**
     * 状态：（0新增完成；1待专业组评分；2待考评组初审；3待考评组长终评；4考评结束）
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 自评分（单位自评）
     */
    @TableField(value = "self_score")
    private Integer selfScore;

    /**
     * 自评理由（单位自评）
     */
    @TableField(value = "self_score_reason")
    private String selfScoreReason;

    /**
     * 支持材料（单位自评）
     */
    @TableField(value = "support_material_self")
    private String supportMaterialSelf;

    /**
     * 建议评分（专业组建议）
     */
    @TableField(value = "suggest_score")
    private Integer suggestScore;

    /**
     * 建议理由（专业组建议）
     */
    @TableField(value = "suggest_reason")
    private String suggestReason;

    /**
     * 支撑材料（专业组建议）
     */
    @TableField(value = "support_material_major")
    private String supportMaterialMajor;

    /**
     * 初评分（初评组初审）
     */
    @TableField(value = "preliminary_score")
    private Integer preliminaryScore;

    /**
     * 初评理由（初评组初审）
     */
    @TableField(value = "preliminary_reason")
    private String preliminaryReason;

    /**
     * 支撑材料（初评组初审）
     */
    @TableField(value = "support_material_prelim")
    private String supportMaterialPrelim;

    /**
     * 终评分（考评组长终评）
     */
    @TableField(value = "final_score")
    private Integer finalScore;

    /**
     * 终评理由（考评组长终评）
     */
    @TableField(value = "final_reason")
    private String finalReason;
}
