package com.ejianc.business.dxcheck.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/28 上午9:53
 * @Description: 考核单位人员
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_dxcheck_user")
public class UserEntity extends BaseEntity {
    /**
     * 序号
     */
    @TableField(value = "serial_num")
    private Integer serialNum;

    /**
     * 考核单位code
     */
    @TableField(value = "assessment_unit_code")
    private String assessmentUnitCode;

    /**
     * 考核单位名称
     */
    @TableField(value = "assessment_unit_name")
    private String assessmentUnitName;
    /**
     * 考核单位ID
     */
    @TableField(value = "assessment_unit_id")
    private Long assessmentUnitId;

    /**
     *考核人所在部门ID
     */
    @TableField(value = "assessment_dept_id")
    private Long assessmentDeptId;
    /**
     *考核人所在部门名称
     */
    @TableField(value = "assessment_dept_name")
    private String assessmentDeptName;

    /**
     * 考核人员工号
     */
    @TableField(value = "assessor_job_num")
    private String assessorJobNum;

    /**
     * 考核人员
     */
    @TableField(value = "assessor_name")
    private String assessorName;
/**
 * 考核人员手机号
 */
    @TableField(value = "assessor_phone")
    private String assessorPhone;

    /**
     * 信息化部门领导工号
     */
    @TableField(value = "leader_info_department_num")
    private String leaderInfoDepartmentNum;

    /**
     * 信息化部门领导
     */
    @TableField(value = "leader_info_department_name")
    private String leaderInfoDepartmentName;
/**
 * 信息化部门领导手机号
 */
    @TableField(value = "leader_info_department_phone")
    private String leaderInfoDepartmentPhone;

    /**
     * 项目分管领导工号
     */
    @TableField(value = "leader_project_management_num")
    private String leaderProjectManagementNum;

    /**
     * 项目分管领导
     */
    @TableField(value = "leader_project_management_name")
    private String leaderProjectManagementName;
    /**
     * 项目分管领导手机号
     */
    @TableField(value = "leader_project_management_phone")
    private String leaderProjectManagementPhone;

    /**
     * 单位负责人领导工号
     */
    @TableField(value = "leader_unit_response_num")
    private String leaderUnitResponseNum;

    /**
     * 单位负责领导
     */
    @TableField(value = "leader_unit_response_name")
    private String leaderUnitResponseName;

    /**
     * 单位负责领导手机号
     */
    @TableField(value = "leader_unit_response_phone")
    private String leaderUnitResponsePhone;

    /**
     * 修改人工号
     */
    @TableField(value = "modifier_job_num")
    private String modifierJobNum;

    /**
     * 修改人
     */
    @TableField(value = "modifier_name")
    private String modifierName;

    /**
     * 修改人手机号
     */
    @TableField(value = "modifier_phone")
    private String modifierPhone;
    /**
     * 修改人修改时间
     */
    @TableField(value = "modify_time")
    private Date modifyTime;


}
