package com.ejianc.business.dxcheck.model.res;

import com.ejianc.business.dxcheck.dao.impl.RecordSubBpmServiceImpl;
import com.ejianc.business.dxcheck.model.NewApproveInfo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/29 上午9:51
 * @Description: 考核记录
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RecordRes {
    /**
     * RecordId
     */
    private Long id;
    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 项目编码
     */
    private String projectCode;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目组织ID
     */
    private Long orgId;

    /**
     * 项目组织编码
     */
    private String orgCode;

    /**
     * 项目组织名称
     */
    private String orgName;

    /**
     * 父级组织ID
     */
    private Long parentOrgId;

    /**
     * 父级组织编码
     */
    private String parentOrgCode;

    /**
     * 父级组织名称
     */
    private String parentOrgName;

    /**
     * 单据编码
     */
    private String billCode;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 考核单位Code
     */
    private String assessmentUnitCode;

    /**
     * 考核单位名称
     */
    private String assessmentUnitName;

    /**
     * 考核部门Code
     */
    private String assessmentDepartmentCode;

    /**
     * 考核部门名称
     */
    private String assessmentDepartmentName;

    /**
     * 考评事件类型（字典项：单位发起评分 考评组发起评分 专业组直接评分 考评组直接评分）
     */
    private String assessmentEventType;

    /**
     * 考核内容
     */
    private String assessmentContent;

    /**
     * 考核人员工号
     */
    private String assessorJobNum;

    /**
     * 考核人员
     */
    private String assessorName;

    /**
     * 修改人工号
     */
    private String modifierJobNum;

    /**
     * 修改人姓名
     */
    private String modifierName;

    /**
     * 状态：（0新增完成；1待专业组评分；2待考评组初审；3待考评组长终评；4考评结束）
     */
    private Integer state;

    /**
     * 批量发起考评编码（专业化组或者考评组批量发起时使用）
     */
    private Integer batchAssessmentCode;
    /**
     * 审批节点用户信息
     */
    @JsonFormat(with = JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY)
    private List<NewApproveInfo> approveUserInfo;

    /**
     * 考核记录子表信息
     */
    private List<RecordSubInfoRes> recordSubEntitiyList;

    private List<Long> removeRecordSubIdList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class RecordSubInfoRes {
        /**
         * RecordSubId
         */
        private Long id;
        /**
         * 审批节点用户信息
         */
        @JsonFormat(with = JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY)
        private List<NewApproveInfo> approveUserInfo;
        /**
         * 考核记录id
         */
        private Long recordId;

        /**
         * 考核单位/部门code
         */
        private String assessmentUnitCode;

        /**
         * 考核单位/部门名称
         */
        private String assessmentUnitName;

        /**
         * 考评事件类型（字典项：单位发起评分 考评组发起评分 专业组直接评分 考评组直接评分）
         */
        private String assessmentEventType;

        /**
         * 考核内容
         */
        private String assessmentContent;

        /**
         * 考核人员工号
         */
        private String assessorJobNum;

        /**
         * 考核人员
         */
        private String assessorName;

        /**
         * 修改人工号
         */
        private String modifierJobNum;

        /**
         * 指标id
         */
        private Long normId;

        /**
         * 指标序号
         */
        private String normNum;

        /**
         * 一级分类
         */
        private String firstClassify;

        /**
         * 二级分类
         */
        private String secondClassify;

        /**
         * 指标内容
         */
        private String normContent;

        /**
         * 加分上限
         */
        private String plusLimit;

        /**
         * 扣分上限制
         */
        private String reduceLimit;

        /**
         * 本部部门（使用选√，不适用—，也可选择单位）
         */
        private String headquarterDepartment;

        /**
         * 分子公司（使用选√，不适用—，也可选择单位）
         */
        private String subsidiaryCompany;

        /**
         * 直管项目（使用选√，不适用—，也可选择单位）
         */
        private String straightProject;

        /**
         * 指标版本
         */
        private String normVersion;

        /**
         * 指标状态
         */
        private String normState;

        /**
         * 分值所属年份（自动带入，可修改）
         */
        private String scoreOfYear;

        /**
         * 分值所属季度（自动带入，可修改）
         */
        private String scoreOfSeason;

        /**
         * 考评主题
         */
        private String assessmentSubject;

        /**
         * 自评分（单位自评）
         */
        private Integer selfScore;

        /**
         * 自评理由（单位自评）
         */
        private String selfScoreReason;

        /**
         * 支持材料（单位自评）
         */
        private String supportMaterialSelf;


        /**
         * 建议评分（专业组建议）
         */
        private Integer suggestScore;

        /**
         * 建议理由（专业组建议）
         */
        private String suggestReason;

        /**
         * 支撑材料（专业组建议）
         */
        private String supportMaterialMajor;

        /**
         * 初评分（初评组初审）
         */
        private Integer preliminaryScore;

        /**
         * 初评理由（初评组初审）
         */
        private String preliminaryReason;

        /**
         * 支撑材料（初评组初审）
         */
        private String supportMaterialPrelim;

        /**
         * 终评分（考评组长终评）
         */
        private Integer finalScore;

        /**
         * 终评理由（考评组长终评）
         */
        private String finalReason;
    }
}
