/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.LambdaUpdateChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dxcheck.dao.RecordDao;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.dao.UserDao;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.entity.UserEntity;
import com.ejianc.business.dxcheck.model.res.RecordRes;
import com.ejianc.business.dxcheck.model.vo.RecordAddEditVo;
import com.ejianc.business.dxcheck.model.vo.RecordBatchAddVo;
import com.ejianc.business.dxcheck.model.vo.RecordDelVo;
import com.ejianc.business.dxcheck.model.vo.RecordScoreVo;
import com.ejianc.business.dxcheck.service.RecordServer;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecordServerImpl
implements RecordServer {
    private static final Logger log = LoggerFactory.getLogger(RecordServerImpl.class);
    private final RecordDao recordDao;
    private final RecordSubDao recordSubDao;
    private final SessionManager sessionManager;
    private final UserDao userDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RecordRes add(RecordAddEditVo vo) {
        UserContext userContext = this.sessionManager.getUserContext();
        RecordEntity recordEntity = new RecordEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)recordEntity));
        recordEntity.setState(NumberUtils.INTEGER_ZERO);
        recordEntity.setOrgId(userContext.getOrgId());
        recordEntity.setOrgCode(userContext.getOrgCode());
        recordEntity.setOrgName(userContext.getOrgName());
        recordEntity.setParentOrgId(userContext.getDeptId());
        recordEntity.setParentOrgCode(userContext.getDeptCode());
        recordEntity.setParentOrgName(userContext.getDeptName());
        this.recordDao.save((Object)recordEntity);
        List saveRecordSubEntityList = Lists.newArrayList();
        List<RecordAddEditVo.AddEditRecordSubInfo> recordSubEntities = vo.getRecordSubEntities();
        recordSubEntities.forEach(e -> {
            BeanUtils.copyProperties((Object)((Object)recordEntity), (Object)e);
            RecordSubEntity recordSubEntity = new RecordSubEntity();
            BeanUtils.copyProperties((Object)e, (Object)((Object)recordSubEntity));
            recordSubEntity.setId(null);
            recordSubEntity.setRecordId(recordEntity.getId());
            recordSubEntity.setState(NumberUtils.INTEGER_ZERO);
            saveRecordSubEntityList.add(recordSubEntity);
        });
        this.recordSubDao.saveBatch(saveRecordSubEntityList);
        return this.buildRes(recordEntity, saveRecordSubEntityList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSubmit(Long id) {
        try {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordDao.lambdaUpdate().eq(BaseEntity::getId, (Object)id)).set(RecordEntity::getState, (Object)NumberUtils.INTEGER_ONE)).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordSubDao.lambdaUpdate().eq(RecordSubEntity::getRecordId, (Object)id)).set(RecordSubEntity::getState, (Object)NumberUtils.INTEGER_ONE)).update();
        }
        catch (Exception e) {
            throw new BusinessException("\u8003\u6838\u8bb0\u5f55\u63d0\u4ea4\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<RecordRes> batchAdd(RecordBatchAddVo vo) {
        UserContext userContext = this.sessionManager.getUserContext();
        String batchAssessmentCode = RandomUtil.randomString((int)20);
        List<RecordBatchAddVo.BathAddRecordInfo> recordInfos = vo.getRecordInfos();
        String assessmentContent = vo.getAssessmentContent();
        String assessmentEventType = vo.getAssessmentEventType();
        List resList = Lists.newArrayList();
        List recordEntityList = Lists.newArrayList();
        List saveRecordSubEntityList = Lists.newArrayList();
        for (RecordBatchAddVo.BathAddRecordInfo recordInfo : recordInfos) {
            RecordEntity recordEntity2 = new RecordEntity();
            BeanUtils.copyProperties((Object)recordInfo, (Object)((Object)recordEntity2));
            recordEntity2.setState(NumberUtils.INTEGER_ZERO);
            recordEntity2.setOrgId(userContext.getOrgId());
            recordEntity2.setOrgCode(userContext.getOrgCode());
            recordEntity2.setOrgName(userContext.getOrgName());
            recordEntity2.setParentOrgId(userContext.getDeptId());
            recordEntity2.setParentOrgCode(userContext.getDeptCode());
            recordEntity2.setParentOrgName(userContext.getDeptName());
            recordEntity2.setBatchAssessmentCode(batchAssessmentCode);
            recordEntity2.setAssessmentContent(assessmentContent);
            recordEntity2.setAssessmentEventType(assessmentEventType);
            this.recordDao.save((Object)recordEntity2);
            recordEntityList.add(recordEntity2);
            Long recordEntityId = recordEntity2.getId();
            List<RecordBatchAddVo.BathAddRecordSubInfo> recordSubEntities = vo.getRecordSubEntities();
            for (RecordBatchAddVo.BathAddRecordSubInfo recordSubEntity : recordSubEntities) {
                String straightProject;
                String headquarterDepartment;
                BeanUtils.copyProperties((Object)((Object)recordEntity2), (Object)recordSubEntity);
                Integer orgType = recordSubEntity.getOrgType();
                if (orgType == 1 && this.normDispose(saveRecordSubEntityList, recordEntityId, assessmentContent, assessmentEventType, recordSubEntity, headquarterDepartment = recordSubEntity.getHeadquarterDepartment()) || orgType == 2 && this.normDispose(saveRecordSubEntityList, recordEntityId, assessmentContent, assessmentEventType, recordSubEntity, straightProject = recordSubEntity.getStraightProject()) || orgType != 3) continue;
                String subsidiaryCompany = recordSubEntity.getSubsidiaryCompany();
                this.normDispose(saveRecordSubEntityList, recordEntityId, assessmentContent, assessmentEventType, recordSubEntity, subsidiaryCompany);
            }
        }
        this.recordSubDao.saveBatch(saveRecordSubEntityList);
        recordEntityList.forEach(recordEntity -> resList.add(this.buildRes((RecordEntity)((Object)recordEntity), saveRecordSubEntityList)));
        return resList;
    }

    private boolean normDispose(List<RecordSubEntity> saveRecordSubEntityList, Long recordEntityId, String assessmentContent, String assessmentEventType, RecordBatchAddVo.BathAddRecordSubInfo recordSubEntity, String unitInfo) {
        if ("\u221a".equals(unitInfo) || unitInfo.equals(recordSubEntity.getAssessmentUnitName())) {
            RecordSubEntity saveRecordSubEntity = new RecordSubEntity();
            BeanUtils.copyProperties((Object)recordSubEntity, (Object)((Object)saveRecordSubEntity));
            saveRecordSubEntity.setId(null);
            saveRecordSubEntity.setRecordId(recordEntityId);
            saveRecordSubEntity.setAssessmentEventType(assessmentEventType);
            saveRecordSubEntity.setAssessmentContent(assessmentContent);
            saveRecordSubEntity.setState(NumberUtils.INTEGER_ZERO);
            saveRecordSubEntityList.add(saveRecordSubEntity);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(RecordDelVo vo) {
        List<Long> ids = vo.getIds();
        List<Long> subIdList = vo.getSubIdList();
        if (!ids.isEmpty()) {
            try {
                this.recordDao.removeByIds(ids);
                ((LambdaUpdateChainWrapper)this.recordSubDao.lambdaUpdate().in(RecordSubEntity::getRecordId, ids)).remove();
                return;
            }
            catch (Exception e) {
                throw new BusinessException("\u5217\u8868\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage());
            }
        }
        if (!subIdList.isEmpty()) {
            try {
                this.recordSubDao.removeByIds(subIdList);
                return;
            }
            catch (Exception e) {
                throw new BusinessException("\u660e\u7ec6\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage());
            }
        }
        throw new BusinessException("\u5217\u8868\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u5220\u9664\u7684\u6761\u76ee");
    }

    @Override
    public RecordRes detail(Long id) {
        RecordEntity recordEntity = (RecordEntity)((Object)((LambdaQueryChainWrapper)this.recordDao.lambdaQuery().eq(BaseEntity::getId, (Object)id)).one());
        if (Objects.isNull((Object)recordEntity)) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25,\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List recordSubEntityList = ((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getRecordId, (Object)id)).list();
        return this.buildRes(recordEntity, recordSubEntityList);
    }

    @Override
    public IPage<RecordEntity> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList(new String[0]));
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        return this.recordDao.queryPage(param, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RecordRes edit(RecordAddEditVo vo) {
        List<Long> removeRecordSubIdList;
        RecordEntity recordEntity = (RecordEntity)((Object)this.recordDao.getById(vo.getId()));
        BeanUtils.copyProperties((Object)vo, (Object)((Object)recordEntity));
        if (StringUtils.isNotEmpty((String)vo.getModificationTime())) {
            recordEntity.setModificationTime((Date)DateUtil.parse((String)vo.getModificationTime()));
        }
        this.recordDao.updateById((Object)recordEntity);
        List<RecordAddEditVo.AddEditRecordSubInfo> recordSubEntities = vo.getRecordSubEntities();
        if (recordSubEntities.isEmpty()) {
            throw new BusinessException("\u81f3\u5c11\u9700\u8981\u4e00\u6761\u6307\u6807");
        }
        List saveRecordSubEntityList = Lists.newArrayList();
        List editRecordSubEntityList = Lists.newArrayList();
        List recordSubIdList = recordSubEntities.stream().map(RecordAddEditVo.AddEditRecordSubInfo::getId).collect(Collectors.toList());
        Map<Long, RecordSubEntity> recordSubIdAndEntityMap = ((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().in(BaseEntity::getId, recordSubIdList)).list().stream().collect(Collectors.toMap(BaseEntity::getId, e -> e));
        recordSubEntities.forEach(e -> {
            Long recordSubId = e.getId();
            if (!recordSubIdAndEntityMap.containsKey(recordSubId)) {
                BeanUtils.copyProperties((Object)((Object)recordEntity), (Object)e);
                e.setRecordId(recordEntity.getId());
                RecordSubEntity saveRecordSubEntity = new RecordSubEntity();
                BeanUtils.copyProperties((Object)e, (Object)((Object)saveRecordSubEntity));
                saveRecordSubEntity.setModifierJobNum(vo.getModifierJobNum());
                saveRecordSubEntity.setState(NumberUtils.INTEGER_ZERO);
                saveRecordSubEntityList.add(saveRecordSubEntity);
            } else {
                RecordSubEntity recordSubEntity = (RecordSubEntity)((Object)((Object)recordSubIdAndEntityMap.get(recordSubId)));
                recordSubEntity.setAssessmentUnitCode(vo.getAssessmentUnitCode());
                recordSubEntity.setAssessmentUnitName(vo.getAssessmentUnitName());
                recordSubEntity.setAssessmentEventType(vo.getAssessmentEventType());
                recordSubEntity.setAssessmentContent(vo.getAssessmentContent());
                recordSubEntity.setAssessorJobNum(vo.getAssessorJobNum());
                recordSubEntity.setAssessorName(vo.getAssessorName());
                recordSubEntity.setScoreOfYear(e.getScoreOfYear());
                recordSubEntity.setScoreOfSeason(e.getScoreOfSeason());
                recordSubEntity.setAssessmentSubject(e.getAssessmentSubject());
                recordSubEntity.setSelfScore(e.getSelfScore());
                recordSubEntity.setSelfScoreReason(e.getSelfScoreReason());
                recordSubEntity.setSupportMaterialSelf(e.getSupportMaterialSelf());
                recordSubEntity.setSuggestScore(e.getSuggestScore());
                recordSubEntity.setSuggestReason(e.getSuggestReason());
                recordSubEntity.setSupportMaterialMajor(e.getSupportMaterialMajor());
                recordSubEntity.setPreliminaryScore(e.getPreliminaryScore());
                recordSubEntity.setPreliminaryReason(e.getPreliminaryReason());
                recordSubEntity.setSupportMaterialPrelim(e.getSupportMaterialPrelim());
                recordSubEntity.setFinalScore(e.getFinalScore());
                recordSubEntity.setFinalReason(e.getFinalReason());
                editRecordSubEntityList.add(recordSubEntity);
            }
        });
        List recordSubEntityList = Lists.newArrayList();
        recordSubEntityList.addAll(saveRecordSubEntityList);
        this.recordSubDao.saveBatch(saveRecordSubEntityList);
        if (!editRecordSubEntityList.isEmpty()) {
            this.recordSubDao.updateBatchById(editRecordSubEntityList);
            recordSubEntityList.addAll(editRecordSubEntityList);
        }
        if (Objects.nonNull(removeRecordSubIdList = vo.getRemoveRecordSubIdList()) && !removeRecordSubIdList.isEmpty()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordSubDao.lambdaUpdate().in(BaseEntity::getId, removeRecordSubIdList)).set(RecordSubEntity::getModifierJobNum, (Object)vo.getModifierJobNum())).update();
            this.recordSubDao.removeByIds(removeRecordSubIdList);
        }
        RecordRes recordRes = this.buildRes(recordEntity, recordSubEntityList);
        recordRes.setRemoveRecordSubIdList(removeRecordSubIdList);
        return recordRes;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void score(RecordScoreVo vo) {
        List<RecordScoreVo.ScoreVo> scoreList = vo.getScoreList();
        try {
            for (RecordScoreVo.ScoreVo scoreVo : scoreList) {
                Integer finalScore;
                Integer preliminaryScore;
                Long recordSubId = scoreVo.getRecordSubId();
                Integer suggestScore = scoreVo.getSuggestScore();
                if (Objects.nonNull(suggestScore)) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordSubDao.lambdaUpdate().eq(BaseEntity::getId, (Object)recordSubId)).set(RecordSubEntity::getState, (Object)2)).set(RecordSubEntity::getSuggestScore, (Object)suggestScore)).set(RecordSubEntity::getSuggestReason, (Object)scoreVo.getSuggestReason())).set(RecordSubEntity::getSupportMaterialMajor, (Object)scoreVo.getSupportMaterialMajor())).update();
                }
                if (Objects.nonNull(preliminaryScore = scoreVo.getPreliminaryScore())) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordSubDao.lambdaUpdate().eq(BaseEntity::getId, (Object)recordSubId)).set(RecordSubEntity::getState, (Object)3)).set(RecordSubEntity::getPreliminaryScore, (Object)preliminaryScore)).set(RecordSubEntity::getPreliminaryReason, (Object)scoreVo.getPreliminaryReason())).set(RecordSubEntity::getSupportMaterialPrelim, (Object)scoreVo.getSupportMaterialPrelim())).update();
                }
                if (!Objects.nonNull(finalScore = scoreVo.getFinalScore())) continue;
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordSubDao.lambdaUpdate().eq(BaseEntity::getId, (Object)recordSubId)).set(RecordSubEntity::getState, (Object)4)).set(RecordSubEntity::getFinalScore, (Object)finalScore)).set(RecordSubEntity::getFinalReason, (Object)scoreVo.getFinalReason())).update();
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u8bc4\u5206\u5931\u8d25\uff0c\u539f\u56e0\uff1a:" + e.getMessage());
        }
        finally {
            Long recordId = vo.getRecordId();
            Integer minState = ((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getRecordId, (Object)recordId)).list().stream().map(RecordSubEntity::getState).min(Integer::compareTo).orElse(0);
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.recordDao.lambdaUpdate().eq(BaseEntity::getId, (Object)recordId)).set(RecordEntity::getState, (Object)minState)).update();
        }
    }

    @Override
    public IPage<UserEntity> checkAssessor(QueryParam param) {
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((String)param.getSearchText())) {
            wrapper.eq(UserEntity::getAssessmentUnitId, (Object)param.getSearchText());
        }
        IPage paged = this.userDao.page((IPage)page, (Wrapper)wrapper);
        return paged;
    }

    @Override
    public IPage<UserEntity> assessmentUnitList(QueryParam param, Integer OrgType) {
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (OrgType != null) {
            wrapper.eq(UserEntity::getOrgType, (Object)OrgType);
        }
        wrapper.groupBy((Object[])new SFunction[]{UserEntity::getAssessmentUnitName});
        IPage paged = this.userDao.page((IPage)page, (Wrapper)wrapper);
        return paged;
    }

    @Override
    public List<com.ejianc.business.dxcheck.model.vo.UserVO> assessmentDeptList(String unitName) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        List list = new ArrayList();
        if (StringUtils.isNotBlank((String)unitName)) {
            if (!"\u4e2d\u56fd\u80fd\u6e90\u5efa\u8bbe\u96c6\u56e2\u6d59\u6c5f\u706b\u7535\u5efa\u8bbe\u6709\u9650\u516c\u53f8\u672c\u90e8".equals(unitName)) {
                return null;
            }
            wrapper.eq(UserEntity::getAssessmentUnitName, (Object)unitName);
            wrapper.groupBy((Object[])new SFunction[]{UserEntity::getAssessmentDeptName});
            list = this.userDao.list((Wrapper)wrapper);
            ArrayList<com.ejianc.business.dxcheck.model.vo.UserVO> vos = new ArrayList<com.ejianc.business.dxcheck.model.vo.UserVO>();
            for (UserEntity userEntity : list) {
                com.ejianc.business.dxcheck.model.vo.UserVO userVO = new com.ejianc.business.dxcheck.model.vo.UserVO();
                BeanUtils.copyProperties((Object)((Object)userEntity), (Object)((Object)userVO));
                userVO.setAssessmentDeptName(userEntity.getAssessmentDeptName());
                userVO.setAssessmentDeptId(userEntity.getAssessmentDeptId());
                userVO.setAssessmentUnitName(userEntity.getAssessmentUnitName());
                userVO.setAssessmentUnitId(String.valueOf(userEntity.getAssessmentUnitId()));
                vos.add(userVO);
            }
            return vos;
        }
        return null;
    }

    private RecordRes buildRes(RecordEntity recordEntity, List<RecordSubEntity> saveRecordSubEntityList) {
        RecordRes recordRes = new RecordRes();
        BeanUtils.copyProperties((Object)((Object)recordEntity), (Object)recordRes);
        String approveUserInfo = recordEntity.getApproveUserInfo();
        List approveUserInfoList = JSONObject.parseArray((String)approveUserInfo, UserVO.class);
        recordRes.setApproveUserInfo(approveUserInfoList);
        List<RecordRes.RecordSubInfoRes> subEntityList = saveRecordSubEntityList.stream().map(recordSubEntity -> {
            RecordRes.RecordSubInfoRes resRecordSubEntity = new RecordRes.RecordSubInfoRes();
            BeanUtils.copyProperties((Object)recordSubEntity, (Object)resRecordSubEntity);
            resRecordSubEntity.setApproveUserInfo(approveUserInfoList);
            return resRecordSubEntity;
        }).collect(Collectors.toList());
        recordRes.setRecordSubEntitiyList(subEntityList);
        return recordRes;
    }

    public RecordServerImpl(RecordDao recordDao, RecordSubDao recordSubDao, SessionManager sessionManager, UserDao userDao) {
        this.recordDao = recordDao;
        this.recordSubDao = recordSubDao;
        this.sessionManager = sessionManager;
        this.userDao = userDao;
    }
}

