package com.ejianc.business.dxcheck.controller;/*author Wyx*/

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dxcheck.entity.TeamEntity;
import com.ejianc.business.dxcheck.entity.TeamUserEntity;
import com.ejianc.business.dxcheck.model.vo.TeamUserVO;
import com.ejianc.business.dxcheck.service.TeamService;
import com.ejianc.business.dxcheck.model.vo.TeamVO;
import com.ejianc.business.dxcheck.service.TeamUserService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
/**
 * @author wyx
 *考核组配置配置
 */
@Controller
@RequestMapping("team")
public class TeamController implements Serializable {

    @Autowired
    private TeamService service;
    @Autowired
    private TeamUserService teamUserService;
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TeamVO>> queryList(@RequestBody QueryParam param,@RequestParam(value = "teamType") int teamType) {
        //组类型查询teamType(1:考评组 2专业组)
        /**模糊搜索配置字段示例*/
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("assessmentUnitName");
        fuzzyFields.add("assessorName");
        fuzzyFields.add("leaderProjectManagementName");
        fuzzyFields.add("leaderUnitResponseName");
        fuzzyFields.add("leaderInfoDepartmentName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("teamType", new Parameter(QueryParam.EQ, teamType));
        IPage<TeamEntity> page = service.queryPage(param, false);
        page.getRecords().forEach(entity -> {
            if (entity.getUpdateUserCode()==null){
                entity.setUpdateUserCode(entity.getCreateUserCode());
                entity.setUpdateTime(entity.getCreateTime());
            }
        });
//        IPage<TeamEntity> page = service.queryPageTeamType(param, teamType);
        if (page==null){
            return CommonResponse.success("查询列表数据失败，请传入正确的类型",null);
        }
        IPage<TeamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TeamVO.class));
        return CommonResponse.success("查询列表数据成功",pageData);
    }

    /**
     * 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TeamVO> queryDetail(Long id) {
        TeamVO vos = service.searchDetail(id);
//        TeamVO vo = BeanMapper.map(entity, TeamVO.class);
        return CommonResponse.success("查询详情数据成功！",vos);
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TeamVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TeamVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(TeamVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TeamVO> saveOrUpdate(@RequestBody TeamVO saveOrUpdateVO){
        System.out.println("打印时间"+saveOrUpdateVO.getModifyTime());
        TeamVO vo= service.saveOrUpdateTeamUser(saveOrUpdateVO);

        return CommonResponse.success("保存或者修改单据成功",vo);
    }

    /**
     * 组成员的添加或者修改
     */
    @RequestMapping(value = "/saveOrUpdateTeamUser", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TeamUserVO> saveOrUpdateTeamUser(@RequestBody TeamUserVO teamUserVO){
        TeamUserEntity entity = BeanMapper.map(teamUserVO, TeamUserEntity.class);
        teamUserService.saveOrUpdate(entity,false);
        TeamUserVO vo = BeanMapper.map(entity, TeamUserVO.class);
        return CommonResponse.success("用户配置保存或者修改单据成功",vo);
    }
    /**
     * 组成员删除
     */
    @RequestMapping(value = "/deleteTeamUser", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteTeamUser(@RequestBody List<TeamUserVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TeamUserVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                //CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
//                if(!resp.isSuccess()){
//                }
            }
        }
        teamUserService.removeByIds(vos.stream().map(TeamUserVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

}
