package com.ejianc.business.dxcheck.model.res;

import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


/**
 * @Author: LCL
 * @Date: 2024/6/5 上午9:23
 * @Description: 考核记录统计返回
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RecordStatisticsRes {
    /**
     * 本季得分
     */
    private Integer quarterScore;
    /**
     * 本年度加减分
     */
    private Integer yearScore;
    /**
     * 年度总分
     */
    private Integer totalAnnualScore;
    /**
     * 板块平均得分
     */
    private BigDecimal plateAverageScore;
    /**
     * 排名
     */
    private Integer rank;
    /**
     * 总数
     */
    private Integer total;
    /**
     * 考核记录情况
     */
    private Map<Long, List<RecordSubEntity>> recordSubMap;
}
