package com.ejianc.business.dxcheck.model.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/4 下午2:05
 * @Description: 批量新增
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RecordBatchAddVo {
    /**
     * 考评事件类型（字典项：单位发起评分 考评组发起评分 专业组直接评分 考评组直接评分）
     */
    @NotEmpty(message = "考评事件类型不能为空")
    private String assessmentEventType;

    /**
     * 考核内容
     */
    @NotEmpty(message = "考核内容不能为空")
    private String assessmentContent;
    /**
     * 批量新增 考核记录子表信息
     */
    @NotNull(message = "考核单位不能为空")
    private List<BathAddRecordInfo> recordInfos;

    /**
     * 批量新增 考核记录子表信息
     */
    @NotNull(message = "指标不能为空")
    private List<BathAddRecordSubInfo> recordSubEntities;


    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class BathAddRecordInfo {
        /**
         * 单据编码
         */
        private String billCode;

        /**
         * 单据状态
         */
        private Integer billState;

        /**
         * 1:本部 2.直管项目 3.分子公司
         */
        @NotNull(message = "orgType不能为空")
        private Integer orgType;

        /**
         * 考核单位id
         */
        @NotEmpty(message = "考核单位id不能为空")
        private String assessmentUnitId;

        /**
         * 考核单位Code
         */
        @NotEmpty(message = "考核单位code不能为空")
        private String assessmentUnitCode;

        /**
         * 考核单位名称
         */
        @NotEmpty(message = "考核单位name不能为空")
        private String assessmentUnitName;

        /**
         * 考核人员工号
         */
        private String assessorJobNum;

        /**
         * 考核人员
         */
        private String assessorName;

        /**
         * 修改人工号
         */
        private String modifierJobNum;

        /**
         * 修改人姓名
         */
        private String modifierName;

        /**
         * 专业组
         */
        private String professionalGroup;

    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class BathAddRecordSubInfo {
        /**
         * 1:本部 2.直管项目 3.分子公司
         */
        private Integer orgType;

        /**
         * 考核单位id
         */
        private String assessmentUnitId;

        /**
         * 考核单位code
         */
        private String assessmentUnitCode;

        /**
         * 考核单位名称
         */
        private String assessmentUnitName;

        /**
         * 考评事件类型（字典项：单位发起评分 考评组发起评分 专业组直接评分 考评组直接评分）
         */
        private String assessmentEventType;

        /**
         * 考核内容
         */
        private String assessmentContent;

        /**
         * 考核人员工号
         */
        private String assessorJobNum;

        /**
         * 考核人员
         */
        private String assessorName;
        /**
         * 指标id
         */
        private Long normId;

        /**
         * 指标序号
         */
        private String normNum;

        /**
         * 一级分类
         */
        private String firstClassify;

        /**
         * 二级分类
         */
        private String secondClassify;

        /**
         * 指标内容
         */
        private String normContent;

        /**
         * 加分上限
         */
        private String plusLimit;

        /**
         * 扣分上限制
         */
        private String reduceLimit;

        /**
         * 本部部门（使用选√，不适用—，也可选择单位）
         */
        private String headquarterDepartment;

        /**
         * 分子公司（使用选√，不适用—，也可选择单位）
         */
        private String subsidiaryCompany;

        /**
         * 直管项目（使用选√，不适用—，也可选择单位）
         */
        private String straightProject;

        /**
         * 指标版本
         */
        private String normVersion;

        /**
         * 指标状态
         */
        private String normState;

        /**
         * 分值所属年份（自动带入，可修改）
         */
        private String scoreOfYear;

        /**
         * 分值所属季度（自动带入，可修改）
         */
        private String scoreOfSeason;

        /**
         * 考评主题
         */
        private String assessmentSubject;

        /**
         * 自评分（单位自评）
         */
        private Integer selfScore;

        /**
         * 自评理由（单位自评）
         */
        private String selfScoreReason;

        /**
         * 支持材料（单位自评）
         */
        private String supportMaterialSelf;
    }
}
