package com.ejianc.business.dxcheck.dao.impl.bpm;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dxcheck.dao.RecordDao;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.model.NewApproveInfo;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.CommonBusinessParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Service("record")
@Slf4j
public class RecordBpmServiceImpl implements ICommonBusinessService {
    @Qualifier("com.ejianc.foundation.orgcenter.api.IUserApi")
    @Autowired
    private IUserApi iUserApi;

    @Autowired
    private RecordDao recordDao;

    @Autowired
    private RecordSubDao recordSubDao;

    /**
     * 提交完回调
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        recordDao.lambdaUpdate().eq(BaseEntity::getId, billId).set(RecordEntity::getState, NumberUtils.INTEGER_ONE).update();
        recordSubDao.lambdaUpdate().eq(RecordSubEntity::getRecordId, billId).set(RecordSubEntity::getState, NumberUtils.INTEGER_ONE).update();
        return CommonResponse.success();
    }
    /**
     * 有审批流的撤回前回调
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        RecordEntity recordEntity = recordDao.lambdaQuery().eq(BaseEntity::getId, billId).one();
        int beforeState = recordEntity.getState() == 0 ? 0 : recordEntity.getState() - 1;
        recordDao.lambdaUpdate().eq(BaseEntity::getId, billId).set(RecordEntity::getState, beforeState).update();
        recordSubDao.lambdaUpdate().eq(RecordSubEntity::getRecordId, billId).set(RecordSubEntity::getState, beforeState).update();
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> approveUserList(CommonBusinessParam businessParam) {
        log.info("record_approveUserList回调：{}", JSONUtil.toJsonStr(businessParam));
        //元数据id(recordSub.id)
        Long billId = businessParam.getBillId();
        JSONArray newApproveInfo = businessParam.getNewApproveInfo();
        List<NewApproveInfo> newApproveInfoList = newApproveInfo.toJavaList(NewApproveInfo.class);
        List<String> approveUserIdList = Lists.newArrayList();
        List<UserVO> approveUserInfoList = Lists.newArrayList();
        String approveUserInfo = "";
        if (!newApproveInfoList.isEmpty()) {
            newApproveInfoList.forEach(e -> {
                approveUserIdList.addAll(e.getApproveUserList());
            });
            CommonResponse<List<UserVO>> userList = iUserApi.queryListByIds(approveUserIdList.toArray(new String[0]));
            List<UserVO> data = userList.getData();
            if (userList.isSuccess() && data != null && !data.isEmpty()) {
                approveUserInfoList.addAll(data);
            }
            //获取节点审批所有用户信息
            approveUserInfo = JSONUtil.toJsonStr(approveUserInfoList);
        }
        RecordEntity one = recordDao.lambdaQuery().eq(BaseEntity::getId, billId).one();
        if (Objects.nonNull(one)) {
            recordSubDao.lambdaUpdate().eq(RecordSubEntity::getRecordId, billId).set(RecordSubEntity::getApproveUserInfo, approveUserInfo).update();
            recordDao.lambdaUpdate().eq(BaseEntity::getId, billId).set(RecordEntity::getApproveUserInfo, approveUserInfo).update();
        }
        return CommonResponse.success();
    }

}
