package com.ejianc.business.dxcheck.model.res;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/4 下午4:33
 * @Description: 考核记录排名
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AssessmentRankRes {
    /**
     * 本部
     */
    private List<AssessmentRankInfo> bb;
    /**
     * 直管项目
     */
    private List<AssessmentRankInfo> zgxm;
    /**
     * 分子公司
     */
    private List<AssessmentRankInfo> fzgs;

    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class AssessmentRankInfo {
        private String unitCode;
        private String unitName;
        private Integer quarterScore;
        private Integer yearScore;
        private Integer totalAnnualScore;
    }
}
