package com.ejianc.business.dxcheck.service.impl;/*author Wyx*/

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dxcheck.dao.TeamDao;
import com.ejianc.business.dxcheck.dao.TeamUserDao;
import com.ejianc.business.dxcheck.entity.TeamEntity;
import com.ejianc.business.dxcheck.entity.TeamUserEntity;
import com.ejianc.business.dxcheck.entity.UserEntity;
import com.ejianc.business.dxcheck.mapper.TeamMapper;
import com.ejianc.business.dxcheck.mapper.UserMapper;
import com.ejianc.business.dxcheck.model.vo.TeamUserVO;
import com.ejianc.business.dxcheck.model.vo.TeamVO;
import com.ejianc.business.dxcheck.service.TeamService;
import com.ejianc.business.dxcheck.service.TeamUserService;
import com.ejianc.business.dxcheck.service.UserService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

@Service("teamService")
public class TeamServiceImpl extends BaseServiceImpl<TeamMapper, TeamEntity> implements TeamService {
    @Autowired
    private TeamDao teamDao;
    @Autowired
    private TeamUserDao teamUserDao;
    @Autowired
    private TeamUserService teamUserService;
    @Override
    public TeamVO searchDetail(Long id) {
        LambdaQueryWrapper<TeamEntity> wrapper = new LambdaQueryWrapper<>();
        if (id != null)
        wrapper.eq(TeamEntity::getId, id);
        TeamEntity teamEntity = teamDao.getOne(wrapper);
        TeamVO vo = BeanMapper.map(teamEntity, TeamVO.class);
        LambdaQueryWrapper<TeamUserEntity> wrapperTeamUser = new LambdaQueryWrapper<>();
        if (vo.getId() != null){
            wrapperTeamUser.eq(TeamUserEntity::getTeamId, vo.getId());
        }
        List<TeamUserEntity> list = teamUserDao.list(wrapperTeamUser);
        List<TeamUserVO> listVo = BeanMapper.mapList(list, TeamUserVO.class);
        vo.setTeamUserList(listVo);

        return vo;
    }

    @Override
    @Transactional
    public TeamVO saveOrUpdateTeamUser(TeamVO saveOrUpdateVO) {
        TeamEntity entity = BeanMapper.map(saveOrUpdateVO, TeamEntity.class);
        saveOrUpdate(entity,false);
        TeamVO vo = BeanMapper.map(entity, TeamVO.class);
        if (saveOrUpdateVO.getTeamUserList()!=null){
            List<TeamUserVO> teamUserVOS=new ArrayList<>();
            for (TeamUserVO teamUserVO : saveOrUpdateVO.getTeamUserList()) {
                teamUserVO.setTeamId(vo.getId());
                TeamUserEntity teamUserEntity = BeanMapper.map(teamUserVO, TeamUserEntity.class);
                teamUserService.saveOrUpdate(teamUserEntity,false);
                TeamUserVO map = BeanMapper.map(teamUserEntity, TeamUserVO.class);
                teamUserVOS.add(map);
            }
            vo.setTeamUserList(teamUserVOS);
        }
        return vo;
    }

//    @Override
//    public IPage<TeamEntity> queryPageTeamType(QueryParam param, int teamType) {
//        Page<TeamEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
//        LambdaQueryWrapper<TeamEntity> wrapper = new LambdaQueryWrapper<>();
//        if (teamType == 1|| teamType==2){
//            wrapper.eq(TeamEntity::getTeamType, teamType);
//        }else {
//            return null;
//        }
//        IPage<TeamEntity> page1 = teamDao.page(page, wrapper);
//        return page1;
//    }


}
