/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dxcheck.dao.RecordDao;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.enums.OrgTypeEnums;
import com.ejianc.business.dxcheck.model.res.AssessmentRankRes;
import com.ejianc.business.dxcheck.model.res.RecordStatisticsRes;
import com.ejianc.business.dxcheck.service.StatisticsServer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StatisticsServerImpl
implements StatisticsServer {
    private static final Logger log = LoggerFactory.getLogger(StatisticsServerImpl.class);
    private final RecordDao recordDao;
    private final RecordSubDao recordSubDao;
    private static final DateTime QUARTER_START_TIME = DateUtil.beginOfQuarter((Date)new Date());
    private static final DateTime QUARTER_END_TIME = DateUtil.endOfQuarter((Date)new Date());
    private static final DateTime YEAR_START_TIME = DateUtil.beginOfYear((Date)new Date());
    private static final DateTime YEAR_END_TIME = DateUtil.endOfYear((Date)new Date());

    @Override
    public JSONArray getTree() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"org_type", "assessment_unit_name", "assessment_unit_code"});
        queryWrapper.groupBy((Object[])new String[]{"org_type", "assessment_unit_name"});
        List recordEntities = this.recordDao.getBaseMapper().selectList((Wrapper)queryWrapper);
        return StatisticsServerImpl.buildTree(recordEntities);
    }

    @Override
    public AssessmentRankRes assessmentRank() {
        List nowQuarterList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).isNotNull(RecordSubEntity::getFinalScore)).between(BaseEntity::getCreateTime, (Object)QUARTER_START_TIME, (Object)QUARTER_END_TIME)).list();
        List nowYearList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).isNotNull(RecordSubEntity::getFinalScore)).between(BaseEntity::getCreateTime, (Object)YEAR_START_TIME, (Object)YEAR_END_TIME)).list();
        List<RecordSubEntity> bbYearList = nowYearList.stream().filter(e -> e.getOrgType() == 1).collect(Collectors.toList());
        List<RecordSubEntity> bbQuarterList = nowQuarterList.stream().filter(e -> e.getOrgType() == 1).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> bbInfoList = this.disposeScores(bbQuarterList, bbYearList);
        List<RecordSubEntity> zgxmYearList = nowYearList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());
        List<RecordSubEntity> zgxmQuarterList = nowQuarterList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> zgxmInfoList = this.disposeScores(zgxmQuarterList, zgxmYearList);
        List<RecordSubEntity> fzgsYearList = nowYearList.stream().filter(e -> e.getOrgType() == 3).collect(Collectors.toList());
        List<RecordSubEntity> fzgsQuarterList = nowQuarterList.stream().filter(e -> e.getOrgType() == 3).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> fzgsInfoList = this.disposeScores(fzgsQuarterList, fzgsYearList);
        return AssessmentRankRes.builder().bb(bbInfoList).zgxm(zgxmInfoList).fzgs(fzgsInfoList).build();
    }

    @Override
    public RecordStatisticsRes record(String unitCode) {
        List recordSubEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getAssessmentUnitCode, (Object)unitCode)).isNotNull(RecordSubEntity::getFinalScore)).list();
        if (recordSubEntityList.isEmpty()) {
            return RecordStatisticsRes.builder().build();
        }
        BigDecimal quarterScore = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)QUARTER_START_TIME) && e.getCreateTime().before((Date)QUARTER_END_TIME)).collect(Collectors.toList()).stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yearScore = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)YEAR_START_TIME) && e.getCreateTime().before((Date)YEAR_END_TIME)).collect(Collectors.toList()).stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAnnualScore = NumberUtil.add((Number)yearScore, (Number)100);
        Integer orgType = ((RecordSubEntity)((Object)recordSubEntityList.get(0))).getOrgType();
        List orgTypeRecordSubList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getOrgType, (Object)orgType)).isNotNull(RecordSubEntity::getFinalScore)).list();
        BigDecimal plateScoreSum = orgTypeRecordSubList.stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        Map<String, List<RecordSubEntity>> collect = orgTypeRecordSubList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitCode));
        int plateSize = collect.size();
        BigDecimal plateAverageScore = plateScoreSum.divide(BigDecimal.valueOf(plateSize)).setScale(2, RoundingMode.HALF_UP);
        int rank = orgTypeRecordSubList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitCode, Collectors.reducing(BigDecimal.ZERO, record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO, BigDecimal::add))).entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).map(Map.Entry::getKey).collect(Collectors.toList()).indexOf(unitCode) + 1;
        return RecordStatisticsRes.builder().quarterScore(quarterScore).yearScore(yearScore).totalAnnualScore(totalAnnualScore).plateAverageScore(plateAverageScore).rank(rank).total(plateSize).recordSubList(recordSubEntityList).build();
    }

    private static JSONArray buildTree(List<RecordEntity> list) {
        Map<Integer, List<RecordEntity>> orgTypeAndUnitInfoListMap = list.stream().collect(Collectors.groupingBy(RecordEntity::getOrgType));
        JSONArray jsonArray = JSONUtil.createArray();
        for (Map.Entry<Integer, List<RecordEntity>> orgTypeAndUnitInfoList : orgTypeAndUnitInfoListMap.entrySet()) {
            Integer orgType = orgTypeAndUnitInfoList.getKey();
            JSONObject node = JSONUtil.createObj();
            node.put("title", (Object)OrgTypeEnums.getNameByCode(orgType));
            node.put("key", (Object)orgType);
            List<RecordEntity> unitInfoList = orgTypeAndUnitInfoList.getValue();
            JSONArray childrenArray = JSONUtil.createArray();
            for (RecordEntity recordEntity : unitInfoList) {
                JSONObject childNode = JSONUtil.createObj();
                childNode.put("title", (Object)recordEntity.getAssessmentUnitName());
                childNode.put("key", (Object)recordEntity.getAssessmentUnitCode());
                childrenArray.add((Object)childNode);
            }
            node.put("children", (Object)childrenArray);
            jsonArray.add((Object)node);
        }
        return jsonArray;
    }

    private List<AssessmentRankRes.AssessmentRankInfo> disposeScores(List<RecordSubEntity> quarterList, List<RecordSubEntity> yearList) {
        List infoList = Lists.newArrayList();
        Map<String, List<RecordSubEntity>> unitYearMap = yearList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitCode));
        Map<String, List<RecordSubEntity>> unitQuarterMap = quarterList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitCode));
        for (Map.Entry<String, List<RecordSubEntity>> unitRecordYearList : unitYearMap.entrySet()) {
            List<RecordSubEntity> recordSubEntityList;
            String unitCode = unitRecordYearList.getKey();
            BigDecimal totalAnnualScore = BigDecimal.valueOf(100L);
            List<RecordSubEntity> recordSubList = unitRecordYearList.getValue();
            BigDecimal yearScore = recordSubList.stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            totalAnnualScore = totalAnnualScore.add(yearScore).setScale(2, RoundingMode.HALF_UP);
            BigDecimal quarterScore = BigDecimal.ZERO;
            if (unitQuarterMap.containsKey(unitCode) && (recordSubEntityList = unitQuarterMap.get(unitCode)) != null) {
                quarterScore = recordSubEntityList.stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            }
            AssessmentRankRes.AssessmentRankInfo infoRes = AssessmentRankRes.AssessmentRankInfo.builder().unitCode(unitCode).unitName(recordSubList.get(0).getAssessmentUnitName()).quarterScore(quarterScore).yearScore(yearScore).totalAnnualScore(totalAnnualScore).build();
            infoList.add(infoRes);
        }
        infoList.sort(Comparator.comparing(AssessmentRankRes.AssessmentRankInfo::getTotalAnnualScore).reversed());
        return infoList;
    }

    public StatisticsServerImpl(RecordDao recordDao, RecordSubDao recordSubDao) {
        this.recordDao = recordDao;
        this.recordSubDao = recordSubDao;
    }
}

