package com.ejianc.business.dxcheck.controller;

import com.ejianc.business.dxcheck.entity.NormEntity;
import com.ejianc.business.dxcheck.model.vo.NormAddVo;
import com.ejianc.business.dxcheck.model.vo.NormEditVo;
import com.ejianc.business.dxcheck.service.NormServer;
import com.ejianc.framework.core.response.CommonResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;


/**
 * @Author: LCL
 * @Date: 2024/5/28 下午2:17
 * @Description: 考核指标
 */
@Controller
@RequestMapping("norm")
@RequiredArgsConstructor
public class NormController {
    private final NormServer server;

    /**
     * 新增
     *
     * @param vo vo
     * @return NormEntity
     */
    @RequestMapping(value = "add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<NormEntity> add(@RequestBody @Valid NormAddVo vo) {
        return CommonResponse.success("考核指标-新增成功", server.add(vo));
    }

    /**
     * 删除
     *
     * @param ids ids
     * @return 结果
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> del(@RequestBody List<Long> ids) {
        server.del(ids);
        return CommonResponse.success("考核指标-删除成功");
    }

    /**
     * 详情
     *
     * @param id id
     * @return NormEntity
     */
    @RequestMapping(value = "detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<NormEntity> detail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("考核指标-详情", server.detail(id));
    }

    /**
     * 列表
     *
     * @return 列表
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, Map<String, List<NormEntity>>>> list() {
        return CommonResponse.success("考核指标-列表", server.list());
    }

    /**
     * 修改
     *
     * @param vo NormEditVo
     * @return 结果
     */
    @RequestMapping(value = "edit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<NormEntity> edit(@RequestBody NormEditVo vo) {
        return CommonResponse.success("考核指标-修改成功", server.edit(vo));
    }

    /**
     * 上移 下移
     *
     * @param id   id
     * @param move 上移up  下移down
     * @return 结果
     */
    @RequestMapping(value = "move", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> move(@RequestParam(value = "id") Long id, @RequestParam(value = "move") String move) {
        return server.move(id, move);
    }
}
