package com.ejianc.business.dxcheck.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
* @Author: LCL
* @Date: 2024/6/15 上午10:04
* @Description: 1:本部 2.直管项目 3.分子公司
*/
@Getter
@AllArgsConstructor
public enum OrgTypeEnums {
    /**
     * 本部
     */
    BB( 1, "本部"),
    /**
     * 直管项目
     */
    ZGXM( 2, "直管项目"),
    /**
     * 分子公司
     */
    FZGS(3, "分子公司");

    /**
     * code
     */
    private  Integer code;
    /**
     * name
     */
    private  String name;

    public static String getNameByCode(Integer code) {
        for (OrgTypeEnums orgTypeEnum : values()) {
            if (orgTypeEnum.getCode().equals(code)) {
                return orgTypeEnum.getName();
            }
        }
        return "未知";
    }
}
