package com.ejianc.business.dxcheck.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.UserEntity;
import com.ejianc.business.dxcheck.model.res.RecordRes;
import com.ejianc.business.dxcheck.model.vo.*;
import com.ejianc.framework.core.response.QueryParam;

import java.util.HashSet;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/29 上午9:43
 * @Description: 考核记录
 */
public interface RecordServer {
    /**
     * 新增
     *
     * @param vo RecordAddVo
     * @return RecordAddRes
     */
    RecordRes add(RecordAddVo vo);

    /**
     * 提交
     *
     * @param id id
     */

    void addSubmit(Long id);

    /**
     * 批量新增
     *
     * @param vo RecordBatchAddVo
     * @return
     */

    List<RecordRes> batchAdd(RecordBatchAddVo vo);

    /**
     * 删除
     *
     * @param vo RecordDelVo
     */
    void del(RecordDelVo vo);

    /**
     * 详情
     *
     * @param id id
     * @return RecordAddRes
     */
    RecordRes detail(Long id);

    /**
     * 列表
     *
     * @param param param
     * @return IPage<RecordEntity>
     */
    IPage<RecordEntity> list(QueryParam param);

    /**
     * 修改
     *
     * @param vo RecordAddEditVo
     * @return RecordAddRes
     */
    RecordRes edit(RecordEditVo vo);

    /**
     * 评分
     *
     * @param vo RecordScoreVo
     * @return 结果
     */
    void score(RecordScoreVo vo);

    IPage<UserEntity> checkAssessor(QueryParam param);

    IPage<UserEntity> assessmentUnitList(QueryParam param,Integer OrgType);

    List<UserVO> assessmentDeptList(String unitName);

    HashSet<Integer> checkUserTeam(Long userID);
}
