package com.ejianc.business.dxcheck.service;


import cn.hutool.json.JSONArray;
import com.ejianc.business.dxcheck.model.res.AssessmentRankRes;
import com.ejianc.business.dxcheck.model.res.RecordStatisticsRes;

/**
 * @Author: LCL
 * @Date: 2024/6/4 下午3:36
 * @Description: 考核排名
 */
public interface StatisticsServer {
    /**
     * 获取排名组织树
     * @return JSONArray
     */
    JSONArray getTree();
    /**
     * 考核排名统计
     *
     * @return AssessmentRankRes
     */
    AssessmentRankRes assessmentRank();

    /**
     * 考核记录统计
     *
     * @param unitCode 部门代码
     * @return 汇总数据
     */
    RecordStatisticsRes record(String unitCode);

}
