package com.ejianc.business.dxcheck.service.impl;/*author Wyx*/

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.dxcheck.dao.TeamDao;
import com.ejianc.business.dxcheck.dao.TeamUserDao;
import com.ejianc.business.dxcheck.entity.TeamEntity;
import com.ejianc.business.dxcheck.entity.TeamUserEntity;
import com.ejianc.business.dxcheck.mapper.TeamMapper;
import com.ejianc.business.dxcheck.mapper.TeamUserMapper;
import com.ejianc.business.dxcheck.model.vo.TeamVO;
import com.ejianc.business.dxcheck.service.TeamService;
import com.ejianc.business.dxcheck.service.TeamUserService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("teamUserService")
public class TeamUserServiceImpl extends BaseServiceImpl<TeamUserMapper, TeamUserEntity> implements TeamUserService {
    @Autowired
    private TeamUserDao teamUserDao;
    @Override
    public void removeTeamUserByTeamId(List<TeamVO> vos) {

        for (TeamVO vo : vos) {
            LambdaQueryWrapper<TeamUserEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(TeamUserEntity::getTeamId, vo.getId());
            teamUserDao.remove(wrapper);
        }
    }
}
