package com.ejianc.business.dxcheck.service.impl;/*author Wyx*/

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dxcheck.entity.UserEntity;
import com.ejianc.business.dxcheck.mapper.UserMapper;
import com.ejianc.business.dxcheck.model.vo.OrgTreeVO;
import com.ejianc.business.dxcheck.service.UserService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Service("userService")
public class UserServiceImpl extends BaseServiceImpl<UserMapper, UserEntity> implements UserService {
    @Autowired
    private IOrgApi iOrgApi;
    //租户ID
    private static final Long TENANT_ID=999999L;
    //总公司名称
    private static final String HEAD_COMPANY = "中国能源建设集团浙江火电建设有限公司本部";
    @Override
    public IPage<OrgVO> OrgTree(QueryParam param, int orgType) {
        String orgName;
        String orgName2=null;
        switch (orgType){
            case 1:
                orgName = HEAD_COMPANY;
                break;
            case 2:
                orgName = "浙江火电直管项目";
                break;
            case 3:
                orgName = "浙江火电分公司";
                orgName2 = "浙江火电子公司";
                break;
            default:
                orgName = "";
        }

        //获取父类组织ID
        CommonResponse<OrgVO> OrgP = iOrgApi.findByNameAndTenantId(orgName, TENANT_ID);
        CommonResponse<OrgVO> OrgP2 = null;
        //通过父类组织ID来查子类列表
        CommonResponse<List<OrgVO>> OrgCList = iOrgApi.getDirectChildrenByPid(OrgP.getData().getId(), "");
        if (orgName2!=null){
             OrgP2=iOrgApi.findByNameAndTenantId(orgName2, TENANT_ID);
            if (OrgP2!=null){
                if (OrgP2.getData()!=null){
                    CommonResponse<List<OrgVO>> OrgCList2= iOrgApi.getDirectChildrenByPid(OrgP2.getData().getId(), "");
                    OrgCList.getData().addAll(OrgCList2.getData());
                }
            }
        }
        //分子公司数据合并

        IPage<OrgVO> iPage=new Page<>(param.getPageIndex(),param.getPageSize());
        int total = OrgCList.getData().size();
        iPage.setTotal(total);
        iPage.setRecords(OrgCList.getData().subList((param.getPageIndex() - 1) * param.getPageSize(), Math.min(param.getPageIndex() * param.getPageSize(), total)));

        return iPage;
    }


}
