package com.ejianc.business.dxcheck.model.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/30 上午9:50
 * @Description: 考核记录评分
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RecordScoreVo {
    /**
     * record.id
     */
    private Long recordId;

    private List<ScoreVo> scoreList;

    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ScoreVo {
        /**
         * record_sub.id
         */
        private Long recordSubId;
        /**
         * 自评分(单位自评)
         */
        private BigDecimal selfScore;

        /**
         * 自评理由
         */
        private String selfScoreReason;

        /**
         * 支持材料（单位自评）
         */
        private String supportMaterialSelf;

        /**
         * 建议评分（专业组建议）
         */
        private BigDecimal suggestScore;

        /**
         * 建议理由（专业组建议）
         */
        private String suggestReason;

        /**
         * 支撑材料（专业组建议）
         */
        private String supportMaterialMajor;

        /**
         * 初评分（初评组初审）
         */
        private BigDecimal preliminaryScore;

        /**
         * 初评理由（初评组初审）
         */
        private String preliminaryReason;

        /**
         * 支撑材料（初评组初审）
         */
        private String supportMaterialPrelim;

        /**
         * 终评分（考评组长终评）
         */
        private BigDecimal finalScore;

        /**
         * 终评理由（考评组长终评）
         */
        private String finalReason;
    }
}
