/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.UserEntity;
import com.ejianc.business.dxcheck.model.res.RecordRes;
import com.ejianc.business.dxcheck.model.vo.RecordAddVo;
import com.ejianc.business.dxcheck.model.vo.RecordBatchAddVo;
import com.ejianc.business.dxcheck.model.vo.RecordDelVo;
import com.ejianc.business.dxcheck.model.vo.RecordEditVo;
import com.ejianc.business.dxcheck.model.vo.RecordScoreVo;
import com.ejianc.business.dxcheck.model.vo.UserVO;
import com.ejianc.business.dxcheck.service.RecordServer;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import java.util.HashSet;
import java.util.List;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"record"})
public class RecordController {
    private final RecordServer server;

    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RecordRes> add(@RequestBody @Valid RecordAddVo vo) {
        return CommonResponse.success((String)"\u8003\u6838\u8bb0\u5f55-\u65b0\u589e\u6210\u529f", (Object)((Object)this.server.add(vo)));
    }

    @RequestMapping(value={"batchAdd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<RecordRes>> batchAdd(@RequestBody @Valid RecordBatchAddVo vo) {
        return CommonResponse.success((String)"\u8003\u6838\u8bb0\u5f55-\u6279\u91cf\u65b0\u589e\u6210\u529f", this.server.batchAdd(vo));
    }

    @RequestMapping(value={"del"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> del(@RequestBody RecordDelVo vo) {
        this.server.del(vo);
        return CommonResponse.success((String)"\u8003\u6838\u8bb0\u5f55-\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"detail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RecordRes> detail(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u8003\u6838\u8bb0\u5f55-\u8be6\u60c5", (Object)((Object)this.server.detail(id)));
    }

    @RequestMapping(value={"list"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RecordEntity>> list(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u8003\u6838\u6307\u6807-\u5217\u8868", this.server.list(param));
    }

    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RecordRes> edit(@RequestBody @Valid RecordEditVo vo) {
        return CommonResponse.success((String)"\u8003\u6838\u8bb0\u5f55-\u4fee\u6539\u6210\u529f", (Object)((Object)this.server.edit(vo)));
    }

    @RequestMapping(value={"score"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Integer> score(@RequestBody @Valid RecordScoreVo vo) {
        return CommonResponse.success((String)"\u8003\u6838\u8bb0\u5f55-\u8bc4\u5206\u6210\u529f", (Object)this.server.score(vo));
    }

    @RequestMapping(value={"check"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UserVO>> check(@RequestBody QueryParam param) {
        IPage<UserEntity> pageEntity = this.server.checkAssessor(param);
        if (pageEntity.getTotal() == 0L) {
            return CommonResponse.error((String)"\u8003\u6838\u4eba\u5458\u672a\u914d\u7f6e");
        }
        Page pageData = new Page(pageEntity.getCurrent(), pageEntity.getSize(), pageEntity.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)pageEntity.getRecords(), UserVO.class));
        return CommonResponse.success((String)"\u8003\u6838\u8bb0\u5f55-\u8003\u6838\u4eba\u5458\u786e\u8ba4\u6210\u529f", (Object)pageData);
    }

    @RequestMapping(value={"assessmentUnitList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UserVO>> assessmentUnitList(@RequestBody QueryParam param) {
        String OrgType = param.getSearchText();
        IPage<UserEntity> pageEntity = this.server.assessmentUnitList(param, Integer.valueOf(OrgType));
        Page pageData = new Page(pageEntity.getCurrent(), pageEntity.getSize(), pageEntity.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)pageEntity.getRecords(), UserVO.class));
        return CommonResponse.success((String)"\u8003\u6838\u8bb0\u5f55-\u8003\u6838\u5355\u4f4d\u5217\u8868", (Object)pageData);
    }

    @RequestMapping(value={"assessmentDeptList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<UserVO>> assessmentDeptList(@RequestParam String unitName) {
        List<UserVO> list = this.server.assessmentDeptList(unitName);
        if (list == null) {
            return CommonResponse.error((String)"\u4ec5\u9700\u8981\u8003\u6838\u4e2d\u56fd\u80fd\u6e90\u5efa\u8bbe\u96c6\u56e2\u6d59\u6c5f\u706b\u7535\u5efa\u8bbe\u6709\u9650\u516c\u53f8\u672c\u90e8");
        }
        return CommonResponse.success((String)"\u8003\u6838\u8bb0\u5f55-\u8003\u6838\u90e8\u95e8\u5217\u8868", list);
    }

    @RequestMapping(value={"checkUserTeam"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<HashSet<Integer>> checkUserTeam() {
        Long userId = InvocationInfoProxy.getUserid();
        HashSet<Integer> set = this.server.checkUserTeam(userId);
        return CommonResponse.success((String)"\u83b7\u53d6\u8003\u8bc4\u7ec4\u6210\u529f(1\uff1a\u8003\u8bc4\u7ec42\uff1a\u4e13\u4e1a\u7ec4)", set);
    }

    public RecordController(RecordServer server) {
        this.server = server;
    }
}

