/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dxcheck.entity.TeamUserEntity;
import com.ejianc.business.dxcheck.model.vo.TeamUserVO;
import com.ejianc.business.dxcheck.model.vo.TeamVO;
import com.ejianc.business.dxcheck.service.TeamService;
import com.ejianc.business.dxcheck.service.TeamUserService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"team"})
public class TeamController
implements Serializable {
    @Autowired
    private TeamService service;
    @Autowired
    private TeamUserService teamUserService;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TeamVO>> queryList(@RequestBody QueryParam param, @RequestParam(value="teamType") int teamType) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("assessmentUnitName");
        fuzzyFields.add("assessorName");
        fuzzyFields.add("leaderProjectManagementName");
        fuzzyFields.add("leaderUnitResponseName");
        fuzzyFields.add("leaderInfoDepartmentName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("teamType", new Parameter("eq", (Object)teamType));
        IPage page = this.service.queryPage(param, false);
        page.getRecords().forEach(entity -> {
            if (entity.getUpdateUserCode() == null) {
                entity.setUpdateUserCode(entity.getCreateUserCode());
                entity.setUpdateTime(entity.getCreateTime());
            }
        });
        if (page == null) {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u7c7b\u578b", null);
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TeamVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TeamVO> queryDetail(Long id) {
        TeamVO vos = this.service.searchDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vos));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TeamVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TeamVO teamVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.teamUserService.removeTeamUserByTeamId(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TeamVO> saveOrUpdate(@RequestBody TeamVO saveOrUpdateVO) {
        System.out.println("\u6253\u5370\u65f6\u95f4" + saveOrUpdateVO.getModifyTime());
        TeamVO vo = this.service.saveOrUpdateTeamUser(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u8005\u4fee\u6539\u5355\u636e\u6210\u529f", (Object)((Object)vo));
    }

    @RequestMapping(value={"/saveOrUpdateTeamUser"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TeamUserVO> saveOrUpdateTeamUser(@RequestBody TeamUserVO teamUserVO) {
        TeamUserEntity entity = (TeamUserEntity)((Object)BeanMapper.map((Object)((Object)teamUserVO), TeamUserEntity.class));
        this.teamUserService.saveOrUpdate((Object)entity, false);
        TeamUserVO vo = (TeamUserVO)((Object)BeanMapper.map((Object)((Object)entity), TeamUserVO.class));
        return CommonResponse.success((String)"\u7528\u6237\u914d\u7f6e\u4fdd\u5b58\u6216\u8005\u4fee\u6539\u5355\u636e\u6210\u529f", (Object)((Object)vo));
    }

    @RequestMapping(value={"/deleteTeamUser"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteTeamUser(@RequestBody List<TeamUserVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TeamUserVO teamUserVO : vos) {
            }
        }
        this.teamUserService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refAssTeamData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TeamVO>> refAssTeamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("teamType", new Parameter("eq", (Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionmap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null == conditionmap.get("createTime")) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11createTime");
            }
            LinkedHashMap ordermap = new LinkedHashMap(conditionmap);
            param.setOrderMap(ordermap);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TeamVO.class));
        IPage<TeamVO> pageDataTeamUser = this.service.setTeamUserList((IPage<TeamVO>)pageData);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f", pageDataTeamUser);
    }

    @RequestMapping(value={"/refProTeamData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TeamVO>> refProTeamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("teamType", new Parameter("eq", (Object)2));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionmap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null == conditionmap.get("createTime")) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11createTime");
            }
            LinkedHashMap ordermap = new LinkedHashMap(conditionmap);
            param.setOrderMap(ordermap);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TeamVO.class));
        IPage<TeamVO> pageDataTeamUser = this.service.setTeamUserList((IPage<TeamVO>)pageData);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f", pageDataTeamUser);
    }

    @RequestMapping(value={"/refTeamUserData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TeamUserVO>> refTeamUserData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionmap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null == conditionmap.get("teamId")) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11teamId");
            }
            param.getParams().put("teamId", new Parameter("eq", conditionmap.get("teamId")));
        }
        IPage page = this.teamUserService.queryPage(param);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TeamUserVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f", (Object)pageData);
    }
}

